/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui;

import io.homo.superresolution.thirdparty.icyllis.modernui.animation.AnimationHandler;
import io.homo.superresolution.thirdparty.icyllis.modernui.core.Core;
import io.homo.superresolution.thirdparty.icyllis.modernui.core.Looper;

public class AnimationSystem {
    private static volatile Thread animationThread;
    private static volatile boolean isInitialized;

    public static synchronized void initialize() {
        if (isInitialized) {
            return;
        }
        long frameTime = 8333L;
        animationThread = new Thread(() -> {
            try {
                while (true) {
                    long currentTimeNanos = System.nanoTime();
                    AnimationHandler.getInstance().doAnimationFrame(Core.timeMillis());
                    Thread.sleep((long)Math.floor(frameTime - (System.nanoTime() - currentTimeNanos) / 1000L), (int)(frameTime - (System.nanoTime() - currentTimeNanos) - (long)Math.floor(frameTime - (System.nanoTime() - currentTimeNanos) / 1000L) * 1000L));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }, "SR-MUI-AnimationThread");
        animationThread.setDaemon(true);
        animationThread.start();
        isInitialized = true;
    }

    public static synchronized void shutdown() {
        if (!isInitialized) {
            return;
        }
        Looper frameLooper = Looper.getFrameLooper();
        if (frameLooper != null) {
            frameLooper.quitSafely();
        }
        if (animationThread != null && animationThread.isAlive()) {
            try {
                animationThread.join(3000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        isInitialized = false;
        animationThread = null;
    }

    public static boolean isAnimationThread() {
        return Thread.currentThread() == animationThread;
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static Thread getAnimationThread() {
        return animationThread;
    }

    static {
        isInitialized = false;
    }
}

