/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.core.backends.interfaces;

import java.util.Arrays;
import org.joml.Vector2f;

public class Transform {
    private float[] mat = Transform.identityMatrix();

    public Transform() {
    }

    public Transform(float[] mat) {
        this.mat = Arrays.copyOf(mat, 6);
    }

    public static float[] identityMatrix() {
        return new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
    }

    public static Transform identity() {
        return new Transform();
    }

    public static float[] multiply(float[] left, float[] right) {
        float a = left[0] * right[0] + left[2] * right[1];
        float b = left[1] * right[0] + left[3] * right[1];
        float c = left[0] * right[2] + left[2] * right[3];
        float d = left[1] * right[2] + left[3] * right[3];
        float e = left[0] * right[4] + left[2] * right[5] + left[4];
        float f = left[1] * right[4] + left[3] * right[5] + left[5];
        return new float[]{a, b, c, d, e, f};
    }

    public float[] getMatrix() {
        return Arrays.copyOf(this.mat, 6);
    }

    public Transform setMatrix(float[] newMat) {
        this.mat = Arrays.copyOf(newMat, 6);
        return this;
    }

    public Transform copy() {
        return new Transform(this.mat);
    }

    public Transform translate(float x, float y) {
        float[] t = new float[]{1.0f, 0.0f, 0.0f, 1.0f, x, y};
        this.mat = Transform.multiply(this.mat, t);
        return this;
    }

    public Transform translate(Vector2f v) {
        return this.translate(v.x(), v.y());
    }

    public Transform scale(float sx, float sy) {
        float[] s = new float[]{sx, 0.0f, 0.0f, sy, 0.0f, 0.0f};
        this.mat = Transform.multiply(this.mat, s);
        return this;
    }

    public Transform scale(float s) {
        return this.scale(s, s);
    }

    public Transform scaleAt(float sx, float sy, float cx, float cy) {
        this.translate(cx, cy);
        this.scale(sx, sy);
        this.translate(-cx, -cy);
        return this;
    }

    public Transform rotate(float radians) {
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        float[] r = new float[]{cos, sin, -sin, cos, 0.0f, 0.0f};
        this.mat = Transform.multiply(this.mat, r);
        return this;
    }

    public Transform rotateAt(float radians, float cx, float cy) {
        this.translate(cx, cy);
        this.rotate(radians);
        this.translate(-cx, -cy);
        return this;
    }

    public Transform rotateDegrees(float degrees) {
        float cos = (float)Math.cos(Math.toDegrees(degrees));
        float sin = (float)Math.sin(Math.toDegrees(degrees));
        float[] r = new float[]{cos, sin, -sin, cos, 0.0f, 0.0f};
        this.mat = Transform.multiply(this.mat, r);
        return this;
    }

    public Transform rotateDegreesAt(float degrees, float cx, float cy) {
        this.translate(cx, cy);
        this.rotate((float)Math.toDegrees(degrees));
        this.translate(-cx, -cy);
        return this;
    }

    public Transform setIdentity() {
        this.mat = Transform.identityMatrix();
        return this;
    }

    public float[] transformMatrix() {
        return this.getMatrix();
    }

    public String toString() {
        float[] m = this.getMatrix();
        return String.format("Transform[[% .3f % .3f % .3f][% .3f % .3f % .3f]]", Float.valueOf(m[0]), Float.valueOf(m[2]), Float.valueOf(m[4]), Float.valueOf(m[1]), Float.valueOf(m[3]), Float.valueOf(m[5]));
    }
}

