/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.widgets;

import io.homo.superresolution.core.gui.MaterialScheme;
import io.homo.superresolution.core.gui.core.AbstractScrollableContainerWidget;
import io.homo.superresolution.core.gui.core.UIInputState;
import io.homo.superresolution.core.gui.core.backends.interfaces.IUIDrawContext;
import io.homo.superresolution.core.gui.core.impl.Rectangle;
import io.homo.superresolution.core.utils.Color;
import org.joml.Vector2f;

public class MaterialScrollableContainerWidget
extends AbstractScrollableContainerWidget {
    private final int SCROLLBAR_SIZE = 8;
    private final int SCROLLBAR_MARGIN = 2;
    private final int MIN_SCROLLBAR_LENGTH = 20;
    protected MaterialScheme scheme = MaterialScheme.defaultLight;
    private Color scrollbarColor = Color.rgba(0.3f, 0.3f, 0.3f, 0.6f);
    private Color scrollbarHoverColor = Color.rgba(0.4f, 0.4f, 0.4f, 0.8f);
    private Color scrollbarActiveColor = Color.rgba(0.5f, 0.5f, 0.5f, 0.9f);
    private boolean verticalScrollbarVisible = false;
    private boolean horizontalScrollbarVisible = false;
    private boolean verticalScrollbarHovered = false;
    private boolean horizontalScrollbarHovered = false;
    private boolean verticalScrollbarDragging = false;
    private boolean horizontalScrollbarDragging = false;
    private Rectangle verticalScrollbarRect = new Rectangle();
    private Rectangle horizontalScrollbarRect = new Rectangle();

    public MaterialScheme scheme() {
        return this.scheme;
    }

    public MaterialScrollableContainerWidget scheme(MaterialScheme scheme) {
        this.scheme = scheme;
        return this;
    }

    @Override
    protected void renderScrollbar(IUIDrawContext drawContext, UIInputState inputState) {
        this.updateScrollbarVisibility();
        Vector2f position = this.getAbsolutePosition();
        Rectangle region = new Rectangle(position.x, position.y, this.viewRegion.x, this.viewRegion.y);
        drawContext.beginBatch();
        drawContext.scissor(region.x, region.y, region.width, region.height);
        this.renderVerticalScrollbar(drawContext, inputState);
        this.renderHorizontalScrollbar(drawContext, inputState);
        drawContext.resetScissor();
        drawContext.endBatch(0);
    }

    private void updateScrollbarVisibility() {
        Vector2f viewRegion = this.getViewRegion().getSize();
        this.verticalScrollbarVisible = this.isVerticalScrollEnabled() && this.getWrapperedLayoutNode().getLayoutHeight() > viewRegion.y;
        this.horizontalScrollbarVisible = this.isHorizontalScrollEnabled() && this.getWrapperedLayoutNode().getLayoutWidth() > viewRegion.x;
    }

    private void renderVerticalScrollbar(IUIDrawContext drawContext, UIInputState inputState) {
        if (!this.verticalScrollbarVisible) {
            return;
        }
        Vector2f scrollOffset = this.getScrollOffset();
        Vector2f absolutePos = this.getAbsolutePosition();
        float scrollbarWidth = 8.0f;
        float scrollbarX = absolutePos.x + this.viewRegion.x - 8.0f - 2.0f;
        float scrollbarY = absolutePos.y + 2.0f;
        float scrollbarHeight = this.viewRegion.y - 4.0f;
        if (this.horizontalScrollbarVisible) {
            scrollbarHeight -= 10.0f;
        }
        float contentHeight = this.getWrapperedLayoutNode().getLayoutHeight();
        float visibleRatio = this.viewRegion.y / contentHeight;
        float thumbHeight = Math.max(scrollbarHeight * visibleRatio, 20.0f);
        float scrollRange = contentHeight - this.viewRegion.y;
        float scrollProgress = scrollOffset.y / scrollRange;
        float thumbY = scrollbarY + (scrollbarHeight - thumbHeight + 2.0f + 2.0f) * scrollProgress;
        this.verticalScrollbarRect.setBounds(scrollbarX, thumbY, scrollbarWidth, thumbHeight);
        Color thumbColor = this.scheme.controlNormal();
        if (this.verticalScrollbarDragging) {
            thumbColor = this.scheme.controlActivated();
        } else if (this.verticalScrollbarHovered) {
            thumbColor = this.scheme.controlHighlight();
        }
        drawContext.drawRoundedRect(scrollbarX, thumbY, scrollbarWidth, thumbHeight, scrollbarWidth / 2.0f, thumbColor, true);
    }

    private void renderHorizontalScrollbar(IUIDrawContext drawContext, UIInputState inputState) {
        if (!this.horizontalScrollbarVisible) {
            return;
        }
        Vector2f viewRegion = this.getViewRegion().getSize();
        Vector2f scrollOffset = this.getScrollOffset();
        Vector2f absolutePos = this.getAbsolutePosition();
        float scrollbarHeight = 8.0f;
        float scrollbarX = absolutePos.x + 2.0f;
        float scrollbarY = absolutePos.y + viewRegion.y - 8.0f - 2.0f;
        float scrollbarWidth = viewRegion.x - 4.0f;
        if (this.verticalScrollbarVisible) {
            scrollbarWidth -= 10.0f;
        }
        float contentWidth = this.getWrapperedLayoutNode().getLayoutWidth();
        float visibleRatio = viewRegion.x / contentWidth;
        float thumbWidth = Math.max(scrollbarWidth * visibleRatio, 20.0f);
        float scrollRange = contentWidth - viewRegion.x;
        float scrollProgress = scrollOffset.x / scrollRange;
        float thumbX = scrollbarX + (scrollbarWidth - thumbWidth) * scrollProgress;
        this.horizontalScrollbarRect.setBounds(thumbX, scrollbarY, thumbWidth, scrollbarHeight);
        Color thumbColor = this.scheme.controlNormal();
        if (this.horizontalScrollbarDragging) {
            thumbColor = this.scheme.controlActivated();
        } else if (this.horizontalScrollbarHovered) {
            thumbColor = this.scheme.controlHighlight();
        }
        drawContext.drawRoundedRect(thumbX, scrollbarY, thumbWidth, scrollbarHeight, scrollbarHeight / 2.0f, thumbColor, true);
    }

    @Override
    public void mouseMove(float x, float y) {
        super.mouseMove(x, y);
        this.verticalScrollbarHovered = this.verticalScrollbarVisible && this.verticalScrollbarRect.in(x, y);
        this.horizontalScrollbarHovered = this.horizontalScrollbarVisible && this.horizontalScrollbarRect.in(x, y);
    }

    @Override
    protected void onMousePressed(Vector2f mousePosition) {
        if (this.verticalScrollbarRect.in(mousePosition.x, mousePosition.y)) {
            this.verticalScrollbarDragging = true;
            return;
        }
        if (this.horizontalScrollbarRect.in(mousePosition.x, mousePosition.y)) {
            this.horizontalScrollbarDragging = true;
            return;
        }
        if (this.findInteractiveWidgetAt(mousePosition) == null) {
            this.isContainerDragging = true;
            this.getScrollHandler().onDragStart(mousePosition);
        }
    }

    @Override
    protected void onMouseDragged(Vector2f mousePosition, Vector2f dragDelta, int button) {
        if (this.verticalScrollbarDragging) {
            this.handleVerticalScrollbarDrag(dragDelta.y);
            return;
        }
        if (this.horizontalScrollbarDragging) {
            this.handleHorizontalScrollbarDrag(dragDelta.x);
            return;
        }
        if (this.isContainerDragging) {
            this.getScrollHandler().onDragMove(mousePosition, dragDelta);
        }
    }

    @Override
    protected void onMouseReleased(Vector2f mousePosition) {
        this.verticalScrollbarDragging = false;
        this.horizontalScrollbarDragging = false;
        if (this.isContainerDragging) {
            this.getScrollHandler().onDragEnd(mousePosition);
            this.isContainerDragging = false;
        }
    }

    private void handleVerticalScrollbarDrag(float mouseY) {
        Vector2f viewRegion = this.getViewRegion().getSize();
        float contentHeight = this.getWrapperedLayoutNode().getLayoutHeight();
        float scrollRange = contentHeight - viewRegion.y;
        if (scrollRange <= 0.0f) {
            return;
        }
        float scrollbarHeight = viewRegion.y - 4.0f;
        if (this.horizontalScrollbarVisible) {
            scrollbarHeight -= 10.0f;
        }
        float visibleRatio = viewRegion.y / contentHeight;
        float thumbHeight = Math.max(scrollbarHeight * visibleRatio, 20.0f);
        float maxThumbMove = scrollbarHeight - thumbHeight;
        float deltaScrollY = mouseY / maxThumbMove * scrollRange;
        float newScrollY = this.getScrollOffset().y + deltaScrollY;
        newScrollY = Math.max(0.0f, Math.min(scrollRange, newScrollY));
        this.getScrollHandler().setScroll(new Vector2f(this.getScrollOffset().x, newScrollY));
    }

    private void handleHorizontalScrollbarDrag(float mouseX) {
        Vector2f viewRegion = this.getViewRegion().getSize();
        float contentWidth = this.getWrapperedLayoutNode().getLayoutWidth();
        float scrollRange = contentWidth - viewRegion.x;
        if (scrollRange <= 0.0f) {
            return;
        }
        float scrollbarWidth = viewRegion.x - 4.0f;
        if (this.verticalScrollbarVisible) {
            scrollbarWidth -= 10.0f;
        }
        float visibleRatio = viewRegion.x / contentWidth;
        float thumbWidth = Math.max(scrollbarWidth * visibleRatio, 20.0f);
        float maxThumbMove = scrollbarWidth - thumbWidth;
        float deltaScrollX = mouseX / maxThumbMove * scrollRange;
        float newScrollX = this.getScrollOffset().x + deltaScrollX;
        newScrollX = Math.max(0.0f, Math.min(scrollRange, newScrollX));
        this.getScrollHandler().setScroll(new Vector2f(newScrollX, this.getScrollOffset().y));
    }

    @Override
    protected Rectangle getAbsoluteViewRect() {
        return new Rectangle(this.getAbsolutePosition().x + this.leftPadding, this.getAbsolutePosition().y + this.topPadding, this.getBounds().width - this.leftPadding - this.rightPadding - (float)(this.verticalScrollbarVisible ? 8 : 0), this.getBounds().height - this.topPadding - this.bottomPadding - (float)(this.horizontalScrollbarVisible ? 8 : 0));
    }

    @Override
    public Rectangle getBounds() {
        Vector2f position = this.getAbsolutePosition();
        return new Rectangle(position.x, position.y, this.viewRegion.x + (float)(this.horizontalScrollEnabled && this.horizontalScrollbarVisible ? 8 : 0), this.viewRegion.y + (float)(this.verticalScrollEnabled && this.verticalScrollbarVisible ? 8 : 0));
    }

    @Override
    public MaterialScrollableContainerWidget setViewRegion(Vector2f viewRegion) {
        this.viewRegion = viewRegion.sub((float)(this.horizontalScrollEnabled && this.horizontalScrollbarVisible ? 8 : 0), (float)(this.verticalScrollEnabled && this.verticalScrollbarVisible ? 8 : 0));
        this.viewRegion.add(0.0f, this.bottomPadding);
        return this;
    }
}

