/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.utils;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class AsyncTimer {
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    public AsyncTimer schedule(Runnable task, long delay, TimeUnit unit) {
        this.scheduler.schedule(() -> {
            try {
                task.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, delay, unit);
        return this;
    }

    public AsyncTimer scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        this.scheduler.scheduleAtFixedRate(() -> {
            try {
                task.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, initialDelay, period, unit);
        return this;
    }

    public void shutdown() {
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(1L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
        }
    }
}

