/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.shadercompat;

import io.homo.superresolution.api.InputResourceSet;
import io.homo.superresolution.api.event.AlgorithmDispatchEvent;
import io.homo.superresolution.api.event.AlgorithmDispatchFinishEvent;
import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.config.SuperResolutionConfig;
import io.homo.superresolution.common.minecraft.handler.RenderHandlerManager;
import io.homo.superresolution.common.minecraft.handler.SRShaderCompatConfig;
import io.homo.superresolution.common.minecraft.handler.TextureInfo;
import io.homo.superresolution.common.perf.PerformanceRecoder;
import io.homo.superresolution.common.upscale.AlgorithmManager;
import io.homo.superresolution.common.upscale.DispatchResource;
import io.homo.superresolution.common.upscale.MotionVectorsGenerator;
import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.impl.CopyOperation;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.graphics.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.graphics.impl.shader.ShaderDescription;
import io.homo.superresolution.core.graphics.impl.shader.ShaderSource;
import io.homo.superresolution.core.graphics.impl.shader.ShaderType;
import io.homo.superresolution.core.graphics.opengl.GlState;
import io.homo.superresolution.core.graphics.opengl.framebuffer.GlFrameBuffer;
import io.homo.superresolution.core.graphics.opengl.framebuffer.GlOnlyNameTexture;
import io.homo.superresolution.core.graphics.opengl.shader.GlShaderProgram;
import io.homo.superresolution.core.graphics.opengl.utils.GlTextureCopier;
import io.homo.superresolution.core.graphics.renderdoc.RenderDoc;
import io.homo.superresolution.shadercompat.IrisShaderPipelineHandle;
import io.homo.superresolution.shadercompat.IrisTextureResolver;
import io.homo.superresolution.shadercompat.SRCompatShaderPack;
import io.homo.superresolution.shadercompat.TextureConfigResolver;
import io.homo.superresolution.shadercompat.mixin.core.ShaderPackAccessor;
import java.util.HashMap;
import java.util.Map;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.pipeline.CompositeRenderer;
import net.minecraft.client.Minecraft;
import org.joml.Vector2f;

public class ShaderCompatUpscaleDispatcher {
    public static Map<String, Object> debugInfo = new HashMap<String, Object>();
    public static TextureInfo colorTexture;
    public static TextureInfo depthTexture;
    public static TextureInfo motionVectorsTexture;
    private static SRShaderCompatConfig.InputTextureConfig lastColorConfig;
    private static SRShaderCompatConfig.InputTextureConfig lastDepthConfig;
    private static SRShaderCompatConfig.InputTextureConfig lastMotionConfig;
    private static GlShaderProgram copyProgram;
    private static GlFrameBuffer copyDstFrameBuffer;
    private static CompositeRenderer cachedCompositeRenderer;

    public static SRShaderCompatConfig.WorldConfig getCurrentConfig() {
        if (!IrisShaderPipelineHandle.shouldApplySuperResolutionChanges()) {
            return null;
        }
        String currentWorldId = ((ShaderPackAccessor)Iris.getCurrentPack().get()).getDimensionMap().get(Iris.getCurrentDimension());
        return IrisShaderPipelineHandle.getCurrentShaderPack().isPresent() ? ((SRCompatShaderPack)IrisShaderPipelineHandle.getCurrentShaderPack().get()).superresolution$getSuperResolutionComaptConfig().getUpscaleConfigForWorld(currentWorldId) : null;
    }

    public static DispatchResource getDispatchResource(CompositeRenderer compositeRenderer) {
        return new DispatchResource(RenderHandlerManager.getRenderWidth(), RenderHandlerManager.getRenderHeight(), new Vector2f((float)RenderHandlerManager.getRenderWidth(), (float)RenderHandlerManager.getRenderHeight()), RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight(), new Vector2f((float)RenderHandlerManager.getScreenWidth(), (float)RenderHandlerManager.getScreenHeight()), RenderHandlerManager.getFrameCount(), PerformanceRecoder.getCpuFrameTimeMs(), (float)AlgorithmManager.param.verticalFov, (float)Math.tan(AlgorithmManager.param.verticalFov / 2.0) * (float)RenderHandlerManager.getRenderWidth() / (float)RenderHandlerManager.getRenderHeight(), 0.05f, Minecraft.getInstance().gameRenderer.getDepthFar(), AlgorithmManager.param.currentModelViewMatrix, AlgorithmManager.param.currentProjectionMatrix, AlgorithmManager.param.currentModelViewProjectionMatrix, AlgorithmManager.param.currentViewMatrix, AlgorithmManager.param.lastModelViewMatrix, AlgorithmManager.param.lastProjectionMatrix, AlgorithmManager.param.lastModelViewProjectionMatrix, AlgorithmManager.param.lastViewMatrix, new InputResourceSet(colorTexture.getInternalTexture(), depthTexture.getInternalTexture(), motionVectorsTexture.getInternalTexture() == null ? AlgorithmManager.getMotionVectorsFrameBuffer().getTexture(FrameBufferAttachmentType.Color) : motionVectorsTexture.getInternalTexture()));
    }

    private static boolean configEquals(SRShaderCompatConfig.OutputTextureConfig c1, SRShaderCompatConfig.OutputTextureConfig c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.enabled == c2.enabled && c1.target.equals(c2.target) && c1.region.equals(c2.region);
    }

    private static boolean configEquals(SRShaderCompatConfig.InputTextureConfig c1, SRShaderCompatConfig.InputTextureConfig c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.enabled == c2.enabled && c1.src.equals(c2.src) && c1.region.equals(c2.region);
    }

    public static void dispatchUpscale(CompositeRenderer compositeRenderer) {
        if (!SuperResolutionConfig.isEnableUpscale()) {
            return;
        }
        if (ShaderCompatUpscaleDispatcher.getCurrentConfig() == null) {
            return;
        }
        PerformanceRecoder.beginUpscale();
        SRShaderCompatConfig.WorldUpscaleConfig currentConfig = ShaderCompatUpscaleDispatcher.getCurrentConfig().upscale_config;
        if (copyProgram == null) {
            copyProgram = RenderSystems.opengl().device().createShaderProgram(ShaderDescription.graphics(new ShaderSource(ShaderType.Fragment, "/shader/copy.frag.glsl", true), new ShaderSource(ShaderType.Vertex, "/shader/copy.vert.glsl", true)).addDefine("COPY_CHANCEL", "4").addDefine("COPY_SRC_CHANCEL0", "0").addDefine("COPY_DST_CHANCEL0", "0").addDefine("COPY_SRC_CHANCEL1", "1").addDefine("COPY_DST_CHANCEL1", "1").addDefine("COPY_SRC_CHANCEL2", "2").addDefine("COPY_DST_CHANCEL2", "2").addDefine("COPY_SRC_CHANCEL3", "3").addDefine("COPY_DST_CHANCEL3", "3").uniformSamplerTexture("tex", 0).build());
            copyProgram.compile();
        }
        boolean needUpdate = false;
        if (!compositeRenderer.equals(cachedCompositeRenderer)) {
            cachedCompositeRenderer = compositeRenderer;
            needUpdate = true;
        }
        SRShaderCompatConfig.InputTextureConfig colorConfig = currentConfig.input_textures.get("color");
        SRShaderCompatConfig.InputTextureConfig depthConfig = currentConfig.input_textures.get("depth");
        SRShaderCompatConfig.InputTextureConfig motionConfig = currentConfig.input_textures.get("motion_vectors");
        SRShaderCompatConfig.OutputTextureConfig outputConfig = currentConfig.output_textures.get("upscaled_color");
        if (colorTexture == null || !ShaderCompatUpscaleDispatcher.configEquals(colorConfig, lastColorConfig) || needUpdate) {
            if (colorTexture != null && colorTexture.getInternalTexture() != null) {
                colorTexture.getInternalTexture().destroy();
            }
            colorTexture = TextureConfigResolver.createForInput(compositeRenderer, colorConfig);
            lastColorConfig = colorConfig;
        }
        if (depthTexture == null || !ShaderCompatUpscaleDispatcher.configEquals(depthConfig, lastDepthConfig) || needUpdate) {
            if (depthTexture != null && depthTexture.getInternalTexture() != null) {
                depthTexture.getInternalTexture().destroy();
            }
            depthTexture = TextureConfigResolver.createForInput(compositeRenderer, depthConfig);
            lastDepthConfig = depthConfig;
        }
        if (motionVectorsTexture == null || !ShaderCompatUpscaleDispatcher.configEquals(motionConfig, lastMotionConfig) || needUpdate) {
            if (motionVectorsTexture != null && motionVectorsTexture.getInternalTexture() != null) {
                motionVectorsTexture.getInternalTexture().destroy();
            }
            motionVectorsTexture = TextureConfigResolver.createForInput(compositeRenderer, motionConfig);
            lastMotionConfig = motionConfig;
        }
        colorTexture.updateTexture();
        depthTexture.updateTexture();
        motionVectorsTexture.updateTexture();
        if (RenderHandlerManager.needCaptureUpscale && RenderDoc.renderdoc != null) {
            RenderDoc.renderdoc.StartFrameCapture.call(null, null);
        }
        AlgorithmManager.update();
        if (SuperResolutionConfig.isGenerateMotionVectors()) {
            MotionVectorsGenerator.update(colorTexture.getInternalTexture(), depthTexture.getInternalTexture());
        }
        DispatchResource dispatchResource = ShaderCompatUpscaleDispatcher.getDispatchResource(compositeRenderer);
        if (SuperResolution.currentAlgorithm != null) {
            AlgorithmDispatchEvent.EVENT.invoker().onAlgorithmDispatch(SuperResolution.currentAlgorithm, dispatchResource);
        }
        try (GlState ignored_ = new GlState();){
            SuperResolution.getCurrentAlgorithm().dispatch(dispatchResource);
        }
        if (SuperResolution.currentAlgorithm != null) {
            AlgorithmDispatchFinishEvent.EVENT.invoker().onAlgorithmDispatchFinish(SuperResolution.currentAlgorithm, SuperResolution.currentAlgorithm.getOutputFrameBuffer().getTexture(FrameBufferAttachmentType.Color));
        }
        if (RenderHandlerManager.needCaptureUpscale && RenderDoc.renderdoc != null) {
            RenderHandlerManager.needCaptureUpscale = false;
            RenderDoc.renderdoc.EndFrameCapture.call(null, null);
        }
        IFrameBuffer outFbo = SuperResolution.getCurrentAlgorithm().getOutputFrameBuffer();
        if (currentConfig.output_textures.get((Object)"upscaled_color").enabled) {
            for (String targetName : currentConfig.output_textures.get((Object)"upscaled_color").target) {
                GlOnlyNameTexture texture = IrisTextureResolver.getIrisTexture(compositeRenderer, targetName);
                if (texture == null) continue;
                GlTextureCopier.copy(CopyOperation.create().src(outFbo.getTexture(FrameBufferAttachmentType.Color)).dst(texture).fromTo(CopyOperation.TextureChancel.A, CopyOperation.TextureChancel.A).fromTo(CopyOperation.TextureChancel.R, CopyOperation.TextureChancel.R).fromTo(CopyOperation.TextureChancel.G, CopyOperation.TextureChancel.G).fromTo(CopyOperation.TextureChancel.B, CopyOperation.TextureChancel.B));
            }
        }
        PerformanceRecoder.endUpscale();
    }
}

