/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.icyllis.arc3d.core;

public class MathUtil {
    public static int clamp(int x, int min, int max) {
        return Math.min(max, Math.max(x, min));
    }

    public static long clamp(long x, long min, long max) {
        return Math.min(max, Math.max(x, min));
    }

    public static float clamp(float x, float min, float max) {
        return Math.min(max, Math.max(x, min));
    }

    public static double clamp(double x, double min, double max) {
        return Math.min(max, Math.max(x, min));
    }

    public static float pin(float x, float min, float max) {
        float y = max < x ? max : x;
        return min < y ? y : min;
    }

    public static double pin(double x, double min, double max) {
        double y = max < x ? max : x;
        return min < y ? y : min;
    }

    public static float min(float a, float b, float c) {
        return Math.min(Math.min(a, b), c);
    }

    public static float min3(float[] v) {
        return Math.min(Math.min(v[0], v[1]), v[2]);
    }

    public static double min(double a, double b, double c) {
        return Math.min(Math.min(a, b), c);
    }

    public static float min(float a, float b, float c, float d) {
        return Math.min(Math.min(a, b), Math.min(c, d));
    }

    public static double min(double a, double b, double c, double d) {
        return Math.min(Math.min(a, b), Math.min(c, d));
    }

    public static float max(float a, float b, float c) {
        return Math.max(Math.max(a, b), c);
    }

    public static double max(double a, double b, double c) {
        return Math.max(Math.max(a, b), c);
    }

    public static float max(float a, float b, float c, float d) {
        return Math.max(Math.max(a, b), Math.max(c, d));
    }

    public static double max(double a, double b, double c, double d) {
        return Math.max(Math.max(a, b), Math.max(c, d));
    }

    public static float lerp(float a, float b, float t) {
        return (b - a) * t + a;
    }

    public static double lerp(double a, double b, double t) {
        return (b - a) * t + a;
    }

    public static float mix(float a, float b, float t) {
        return a * (1.0f - t) + b * t;
    }

    public static double mix(double a, double b, double t) {
        return a * (1.0 - t) + b * t;
    }

    public static int ceilLog2(float v) {
        int exp = (Float.floatToRawIntBits(v) + 0x800000 - 1 >> 23) - 127;
        return exp & ~(exp >> 31);
    }

    public static int ceilLog4(float v) {
        return MathUtil.ceilLog2(v) + 1 >> 1;
    }

    public static int ceilLog16(float v) {
        return MathUtil.ceilLog2(v) + 3 >> 2;
    }

    protected MathUtil() {
        throw new UnsupportedOperationException();
    }
}

