/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.numeric;

public final class Comparison {
    private Comparison() {
    }

    public static boolean isUndefined(float value) {
        return Float.isNaN(value);
    }

    public static boolean isUndefined(double value) {
        return Double.isNaN(value);
    }

    public static boolean isDefined(float value) {
        return !Comparison.isUndefined(value);
    }

    public static boolean isDefined(double value) {
        return !Comparison.isUndefined(value);
    }

    public static boolean isInf(float value) {
        return Float.isInfinite(value);
    }

    public static boolean isInf(double value) {
        return Double.isInfinite(value);
    }

    public static float maxOrDefined(float a, float b) {
        if (Comparison.isDefined(a) && Comparison.isDefined(b)) {
            return Math.max(a, b);
        }
        return Comparison.isUndefined(a) ? b : a;
    }

    public static double maxOrDefined(double a, double b) {
        if (Comparison.isDefined(a) && Comparison.isDefined(b)) {
            return Math.max(a, b);
        }
        return Comparison.isUndefined(a) ? b : a;
    }

    public static float minOrDefined(float a, float b) {
        if (Comparison.isDefined(a) && Comparison.isDefined(b)) {
            return Math.min(a, b);
        }
        return Comparison.isUndefined(a) ? b : a;
    }

    public static double minOrDefined(double a, double b) {
        if (Comparison.isDefined(a) && Comparison.isDefined(b)) {
            return Math.min(a, b);
        }
        return Comparison.isUndefined(a) ? b : a;
    }

    public static boolean inexactEquals(float a, float b) {
        if (Comparison.isDefined(a) && Comparison.isDefined(b)) {
            return Math.abs(a - b) < 1.0E-4f;
        }
        return Comparison.isUndefined(a) && Comparison.isUndefined(b);
    }

    public static boolean inexactEquals(double a, double b) {
        if (Comparison.isDefined(a) && Comparison.isDefined(b)) {
            return Math.abs(a - b) < 1.0E-4;
        }
        return Comparison.isUndefined(a) && Comparison.isUndefined(b);
    }

    public static boolean inexactEquals(float[] val1, float[] val2) {
        if (val1.length != val2.length) {
            return false;
        }
        for (int i = 0; i < val1.length; ++i) {
            if (Comparison.inexactEquals(val1[i], val2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean inexactEquals(double[] val1, double[] val2) {
        if (val1.length != val2.length) {
            return false;
        }
        for (int i = 0; i < val1.length; ++i) {
            if (Comparison.inexactEquals(val1[i], val2[i])) continue;
            return false;
        }
        return true;
    }
}

