/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.style;

import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaUnit;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaValue;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.numeric.FloatOptional;

public class StyleLength {
    private static final StyleLength AUTO = new StyleLength(FloatOptional.of(), YogaUnit.AUTO);
    private static final StyleLength UNDEFINED = new StyleLength(FloatOptional.of(), YogaUnit.UNDEFINED);
    private final FloatOptional value;
    private final YogaUnit unit;

    private StyleLength(FloatOptional value, YogaUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    public static StyleLength points(float value) {
        return Float.isNaN(value) || Float.isInfinite(value) ? StyleLength.undefined() : new StyleLength(FloatOptional.of(value), YogaUnit.POINT);
    }

    public static StyleLength percent(float value) {
        return Float.isNaN(value) || Float.isInfinite(value) ? StyleLength.undefined() : new StyleLength(FloatOptional.of(value), YogaUnit.PERCENT);
    }

    public static StyleLength ofAuto() {
        return AUTO;
    }

    public static StyleLength undefined() {
        return UNDEFINED;
    }

    public boolean isAuto() {
        return this.unit == YogaUnit.AUTO;
    }

    public boolean isUndefined() {
        return this.unit == YogaUnit.UNDEFINED;
    }

    public boolean isPoints() {
        return this.unit == YogaUnit.POINT;
    }

    public boolean isPercent() {
        return this.unit == YogaUnit.PERCENT;
    }

    public boolean isDefined() {
        return !this.isUndefined();
    }

    public FloatOptional value() {
        return this.value;
    }

    public FloatOptional resolve(float referenceLength) {
        return switch (this.unit) {
            case YogaUnit.POINT -> this.value;
            case YogaUnit.PERCENT -> FloatOptional.of(this.value.unwrap() * referenceLength * 0.01f);
            default -> FloatOptional.of();
        };
    }

    public YogaValue asYogaValue() {
        return new YogaValue(this.value.unwrap(), this.unit);
    }

    public static StyleLength fromYogaValue(YogaValue value) {
        return new StyleLength(FloatOptional.of(value.value), value.unit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StyleLength other = (StyleLength)obj;
        return this.value.equals(other.value) && this.unit == other.unit;
    }

    public boolean inexactEquals(StyleLength other) {
        return this.unit == other.unit && this.value.inexactEquals(other.value);
    }
}

