/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.gui.options;

import io.homo.superresolution.common.gui.impl.OptionRequirement;
import io.homo.superresolution.common.gui.impl.Text;
import io.homo.superresolution.common.gui.options.AbstractOptionEntry;
import io.homo.superresolution.common.gui.options.OptionCategory;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractOptionBuilder<VT, OT extends AbstractOptionEntry<VT, OT>, SELF> {
    protected boolean requireRestartGame = false;
    @Nullable
    protected Supplier<VT> defaultValue = null;
    @Nullable
    protected Function<VT, Optional<Text>> errorSupplier;
    @Nullable
    protected OptionRequirement enableRequirement = null;
    @Nullable
    protected OptionRequirement displayRequirement = null;
    protected Consumer<VT> saveConsumer = null;
    protected Function<VT, Optional<Text[]>> tooltipSupplier = list -> Optional.empty();
    protected VT value;
    protected Text name;
    protected OptionCategory category;

    protected OptionCategory getCategory() {
        return this.category;
    }

    protected SELF setCategory(OptionCategory category) {
        this.category = category;
        return (SELF)this;
    }

    public AbstractOptionBuilder(Text name, VT value) {
        this.name = name;
        this.value = value;
    }

    public abstract OT build();

    protected OT finishBuild(OT option) {
        ((AbstractOptionEntry)option).setDefaultValue(this.defaultValue);
        ((AbstractOptionEntry)option).setErrorSupplier(this.errorSupplier);
        ((AbstractOptionEntry)option).setEnableRequirement(this.enableRequirement);
        ((AbstractOptionEntry)option).setDisplayRequirement(this.displayRequirement);
        ((AbstractOptionEntry)option).setRequiresRestartGame(this.requireRestartGame);
        ((AbstractOptionEntry)option).setSaveConsumer(this.saveConsumer);
        ((AbstractOptionEntry)option).setTooltipSupplier(this.tooltipSupplier);
        this.category.addEntry((AbstractOptionEntry<?, ?>)option);
        return option;
    }

    public SELF setValue(VT value) {
        this.value = value;
        return (SELF)this;
    }

    public SELF setName(Text name) {
        this.name = name;
        return (SELF)this;
    }

    public SELF setRequireRestartGame(boolean requireRestartGame) {
        this.requireRestartGame = requireRestartGame;
        return (SELF)this;
    }

    public SELF setDefaultValue(@Nullable Supplier<VT> defaultValue) {
        this.defaultValue = defaultValue;
        return (SELF)this;
    }

    public SELF setErrorSupplier(@Nullable Function<VT, Optional<Text>> errorSupplier) {
        this.errorSupplier = errorSupplier;
        return (SELF)this;
    }

    public SELF setEnableRequirement(@Nullable OptionRequirement enableRequirement) {
        this.enableRequirement = enableRequirement;
        return (SELF)this;
    }

    public SELF setDisplayRequirement(@Nullable OptionRequirement displayRequirement) {
        this.displayRequirement = displayRequirement;
        return (SELF)this;
    }

    public SELF setSaveConsumer(Consumer<VT> saveConsumer) {
        this.saveConsumer = saveConsumer;
        return (SELF)this;
    }

    public SELF setTooltipSupplier(Function<VT, Optional<Text[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return (SELF)this;
    }
}

