/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.graphics.impl.framebuffer.IBindableFrameBuffer;
import io.homo.superresolution.core.graphics.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureDescription;
import io.homo.superresolution.core.graphics.impl.texture.TextureFilterMode;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.impl.texture.TextureMipmapSettings;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsages;
import io.homo.superresolution.core.graphics.impl.texture.TextureWrapMode;
import io.homo.superresolution.core.graphics.opengl.GlDebug;
import org.lwjgl.opengl.GL43;

public class LegacyStorageFrameBuffer
extends RenderTarget
implements IFrameBuffer,
IBindableFrameBuffer {
    private int colorAttachment1 = -1;
    private boolean stencilEnabled = false;
    private String label;

    public LegacyStorageFrameBuffer(boolean useDepth) {
        super(useDepth);
    }

    public void createBuffers(int width, int height) {
        RenderSystem.assertOnRenderThreadOrInit();
        int maxSupportedTextureSize = RenderSystem.maxSupportedTextureSize();
        if (width > 0 && width <= maxSupportedTextureSize && height > 0 && height <= maxSupportedTextureSize) {
            this.viewWidth = width;
            this.viewHeight = height;
            this.width = width;
            this.height = height;
            this.filterMode = 9728;
            this.frameBufferId = GL43.glGenFramebuffers();
            this.colorTextureId = TextureUtil.generateTextureId();
            this.depthBufferId = TextureUtil.generateTextureId();
            this.colorAttachment1 = TextureUtil.generateTextureId();
            if (this.label == null) {
                this.label = "SRLegacyStorageFrameBuffer";
            }
            GL43.glBindFramebuffer((int)36160, (int)this.frameBufferId);
            GL43.glBindTexture((int)3553, (int)this.depthBufferId);
            GL43.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL43.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL43.glTexParameteri((int)3553, (int)34892, (int)0);
            GL43.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL43.glTexParameteri((int)3553, (int)10243, (int)33071);
            if (this.stencilEnabled) {
                GL43.glTexStorage2D((int)3553, (int)1, (int)35056, (int)this.width, (int)this.height);
                GL43.glFramebufferTexture2D((int)36160, (int)36128, (int)3553, (int)this.depthBufferId, (int)0);
            } else {
                GL43.glTexStorage2D((int)3553, (int)1, (int)33190, (int)this.width, (int)this.height);
            }
        } else {
            throw new IllegalArgumentException("Window " + width + "x" + height + " size out of bounds (max. size: " + maxSupportedTextureSize + ")");
        }
        GL43.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)this.depthBufferId, (int)0);
        GL43.glBindTexture((int)3553, (int)this.colorTextureId);
        GL43.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL43.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL43.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL43.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL43.glTexStorage2D((int)3553, (int)1, (int)32856, (int)this.width, (int)this.height);
        GL43.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.colorTextureId, (int)0);
        GL43.glBindTexture((int)3553, (int)this.colorAttachment1);
        GL43.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL43.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL43.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL43.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL43.glTexStorage2D((int)3553, (int)1, (int)TextureFormat.RG16F.gl(), (int)this.width, (int)this.height);
        this.checkStatus();
        this.clear();
        this.unbindRead();
        GlDebug.objectLabel(36160, this.frameBufferId, this.label);
        GlDebug.objectLabel(5890, this.colorTextureId, this.label + "-ColorTexture");
        GlDebug.objectLabel(5890, this.depthBufferId, this.label + "-DepthTexture");
    }

    public void enableStencil() {
        if (!this.stencilEnabled) {
            this.stencilEnabled = true;
            this.resize(this.viewWidth, this.viewHeight);
        }
    }

    public boolean isStencilEnabled() {
        return this.stencilEnabled;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void destroy() {
        this.destroyBuffers();
    }

    @Override
    public void clearFrameBuffer() {
        this.clear();
    }

    @Override
    public void resizeFrameBuffer(int width, int height) {
        this.resize(width, height);
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint, boolean setViewport) {
        if (bindPoint == FrameBufferBindPoint.Read) {
            this.bindRead();
        } else {
            this.bindWrite(setViewport);
        }
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint) {
        this.bind(bindPoint, true);
    }

    @Override
    public void unbind(FrameBufferBindPoint bindPoint) {
        if (bindPoint == FrameBufferBindPoint.Read) {
            this.unbindRead();
        } else if (bindPoint == FrameBufferBindPoint.Write) {
            this.unbindWrite();
        } else {
            this.unbindRead();
            this.unbindWrite();
        }
    }

    @Override
    public int getTextureId(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new MatchException(null, null);
            case FrameBufferAttachmentType.Color -> {
                if (attachmentType.getIndex() == 0) {
                    yield this.colorTextureId;
                }
                yield this.colorAttachment1;
            }
            case FrameBufferAttachmentType.AnyDepth, FrameBufferAttachmentType.Depth -> this.depthBufferId;
            case FrameBufferAttachmentType.DepthStencil -> this.stencilEnabled ? this.depthBufferId : -1;
        };
    }

    @Override
    public ITexture getTexture(FrameBufferAttachmentType attachmentType) {
        return attachmentType == FrameBufferAttachmentType.Color ? new LegacyFrameBufferTextureAdapter(false, false) : new LegacyFrameBufferTextureAdapter(true, this.stencilEnabled);
    }

    @Override
    public long handle() {
        return this.frameBufferId;
    }

    @Override
    public TextureFormat getColorTextureFormat() {
        return TextureFormat.RGBA8;
    }

    @Override
    public TextureFormat getDepthTextureFormat() {
        return this.stencilEnabled ? TextureFormat.DEPTH24_STENCIL8 : TextureFormat.DEPTH24;
    }

    @Override
    public void setClearColorRGBA(float red, float green, float blue, float alpha) {
        super.setClearColor(red, green, blue, alpha);
    }

    @Override
    public RenderTarget asMcRenderTarget() {
        return this;
    }

    @Override
    public void label(String label) {
        this.label = label;
    }

    class LegacyFrameBufferTextureAdapter
    implements ITexture {
        private final boolean isDepth;
        private final boolean isStencil;

        private LegacyFrameBufferTextureAdapter(boolean isDepth, boolean isStencil) {
            this.isDepth = isDepth;
            this.isStencil = isStencil;
        }

        @Override
        public TextureFormat getTextureFormat() {
            if (this.isDepth && this.isStencil) {
                return TextureFormat.DEPTH24_STENCIL8;
            }
            if (this.isDepth) {
                return TextureFormat.DEPTH24;
            }
            return TextureFormat.RGBA8;
        }

        @Override
        public TextureUsages getTextureUsages() {
            return TextureUsages.create().sampler().storage().copy();
        }

        @Override
        public TextureDescription getTextureDescription() {
            return TextureDescription.create().filterMode(this.getTextureFilterMode()).format(this.getTextureFormat()).size(this.getWidth(), this.getHeight()).type(this.getTextureType()).wrapMode(this.getTextureWrapMode()).mipmapSettings(this.getMipmapSettings()).usages(this.getTextureUsages()).build();
        }

        @Override
        public TextureType getTextureType() {
            return TextureType.Texture2D;
        }

        @Override
        public TextureFilterMode getTextureFilterMode() {
            return TextureFilterMode.Nearest;
        }

        @Override
        public TextureWrapMode getTextureWrapMode() {
            return TextureWrapMode.ClampToEdge;
        }

        @Override
        public TextureMipmapSettings getMipmapSettings() {
            return TextureMipmapSettings.disabled();
        }

        @Override
        public int getWidth() {
            return LegacyStorageFrameBuffer.this.width;
        }

        @Override
        public int getHeight() {
            return LegacyStorageFrameBuffer.this.height;
        }

        @Override
        public long handle() {
            return this.isDepth ? (long)LegacyStorageFrameBuffer.this.depthBufferId : (long)LegacyStorageFrameBuffer.this.colorTextureId;
        }

        @Override
        public void destroy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void resize(int width, int height) {
            throw new UnsupportedOperationException();
        }
    }
}

