/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft.handler;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public class SRShaderCompatConfig {
    public UpscaleConfig sr;
    public UpscaleJitterConfig sr_jitter;

    public static SRShaderCompatConfig loadFromJson(Path file) throws IOException {
        Gson gson = new GsonBuilder().create();
        return (SRShaderCompatConfig)gson.fromJson(Files.readString(file), SRShaderCompatConfig.class);
    }

    public WorldConfig getUpscaleConfigForWorld(String worldId) {
        if (this.sr == null || this.sr.worlds == null) {
            return null;
        }
        WorldConfig wc = this.sr.worlds.get(worldId = worldId.replace("world", ""));
        if (wc != null && wc.upscale_config != null) {
            return wc;
        }
        return this.sr.worlds.get("*") != null ? this.sr.worlds.get("*") : null;
    }

    public WorldUpscaleJitterConfig getUpscaleJitterConfigForWorld(String worldId) {
        if (this.sr_jitter == null || this.sr_jitter.worlds == null) {
            return null;
        }
        WorldUpscaleJitterConfig wc = this.sr_jitter.worlds.get(worldId = worldId.replace("world", ""));
        if (wc != null) {
            return wc;
        }
        return this.sr_jitter.worlds.get("*") != null ? this.sr_jitter.worlds.get("*") : null;
    }

    public static class UpscaleConfig {
        public boolean enabled;
        public Map<String, WorldConfig> worlds;
    }

    public static class WorldConfig {
        public boolean enabled;
        public WorldUpscaleConfig upscale_config;
    }

    public static class WorldUpscaleConfig {
        public String before_upscale_shader_name;
        public String sr_internal_texture_format;
        public Map<String, InputTextureConfig> input_textures;
        public Map<String, OutputTextureConfig> output_textures;

        public TextureFormat getSrInternalTextureFormat() {
            if (this.sr_internal_texture_format == null) {
                return TextureFormat.R11G11B10F;
            }
            return switch (this.sr_internal_texture_format) {
                case "r11b11g10f" -> TextureFormat.R11G11B10F;
                case "rgb8" -> TextureFormat.RGB8;
                case "rgba8" -> TextureFormat.RGBA8;
                case "rgba16f" -> TextureFormat.RGBA16F;
                case "rgba16" -> TextureFormat.RGBA16;
                case "rgb16f" -> TextureFormat.RGB16F;
                default -> TextureFormat.R11G11B10F;
            };
        }
    }

    public static class UpscaleJitterConfig {
        public boolean enabled;
        public Map<String, WorldUpscaleJitterConfig> worlds;
    }

    public static class WorldUpscaleJitterConfig {
        public boolean enabled;
    }

    public static class OutputTextureConfig
    extends TextureConfig {
        public List<String> target;
    }

    public static class InputTextureConfig
    extends TextureConfig {
        public String src;
    }

    public static class TextureConfig {
        public boolean enabled;
        public List<Integer> region;
    }
}

