/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl.pipeline;

import io.homo.superresolution.core.graphics.impl.command.ICommandBuffer;
import io.homo.superresolution.core.graphics.impl.pipeline.IPipelineJob;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import java.util.Objects;

public class PipelineClearTextureJob
implements IPipelineJob {
    protected float[] clearColor = null;
    protected Float clearDepth = null;
    protected Integer clearStencil = null;
    protected ITexture target = null;

    public PipelineClearTextureJob clearColor(float r, float g, float b, float a) {
        this.validateColorComponent(r);
        this.validateColorComponent(g);
        this.validateColorComponent(b);
        this.validateColorComponent(a);
        this.clearColor = new float[]{r, g, b, a};
        return this;
    }

    public PipelineClearTextureJob clearDepth(float depth) {
        if (depth < 0.0f || depth > 1.0f) {
            throw new IllegalArgumentException("\u6df1\u5ea6\u503c\u5fc5\u987b\u5728[0,1]\u8303\u56f4\u5185");
        }
        this.clearDepth = Float.valueOf(depth);
        return this;
    }

    public PipelineClearTextureJob clearStencil(int stencil) {
        if (stencil < 0 || stencil > 255) {
            throw new IllegalArgumentException("\u6a21\u677f\u503c\u5fc5\u987b\u5728[0,255]\u8303\u56f4\u5185");
        }
        this.clearStencil = stencil;
        return this;
    }

    public PipelineClearTextureJob clearTarget(ITexture target) {
        this.target = Objects.requireNonNull(target, "\u6e05\u9664\u76ee\u6807\u4e0d\u80fd\u4e3anull");
        return this;
    }

    @Override
    public void execute(ICommandBuffer commandBuffer) {
        this.validateState();
        boolean cleared = false;
        if (this.clearColor != null) {
            this.validateChannels(this.clearColor.length, this.target.getTextureFormat().getChannelCount());
            commandBuffer.getEncoder().clearTextureRGBA(commandBuffer, this.target, this.clearColor);
            cleared = true;
        }
        if (this.clearDepth != null) {
            this.validateDepthSupport();
            commandBuffer.getEncoder().clearTextureDepth(commandBuffer, this.target, this.clearDepth.floatValue());
            cleared = true;
        }
        if (this.clearStencil != null) {
            this.validateStencilSupport();
            commandBuffer.getEncoder().clearTextureStencil(commandBuffer, this.target, this.clearStencil);
            cleared = true;
        }
        if (!cleared) {
            throw new IllegalStateException("\u65e0\u6709\u6548\u7684\u6e05\u9664\u64cd\u4f5c\u914d\u7f6e");
        }
    }

    private void validateState() {
        Objects.requireNonNull(this.target, "\u6e05\u9664\u76ee\u6807\u672a\u8bbe\u7f6e");
    }

    private void validateColorComponent(float c) {
        if (c < 0.0f || c > 1.0f) {
            throw new IllegalArgumentException("\u989c\u8272\u5206\u91cf\u5fc5\u987b\u5728[0,1]\u8303\u56f4\u5185");
        }
    }

    private void validateChannels(int actual, int expected) {
        if (actual != expected) {
            throw new IllegalStateException(String.format("\u989c\u8272\u5206\u91cf\u6570(%d)\u4e0e\u7eb9\u7406\u901a\u9053\u6570(%d)\u4e0d\u5339\u914d", actual, expected));
        }
    }

    private void validateDepthSupport() {
        if (!this.target.getTextureFormat().isDepth()) {
            throw new UnsupportedOperationException("\u7eb9\u7406\u4e0d\u652f\u6301\u6df1\u5ea6\u6e05\u9664");
        }
    }

    private void validateStencilSupport() {
        if (!this.target.getTextureFormat().isStencil()) {
            throw new UnsupportedOperationException("\u7eb9\u7406\u4e0d\u652f\u6301\u6a21\u677f\u6e05\u9664");
        }
    }

    @Override
    public void destroy() {
        this.clearColor = null;
        this.clearDepth = null;
        this.clearStencil = null;
        this.target = null;
    }
}

