/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl.pipeline;

import io.homo.superresolution.core.graphics.impl.command.ICommandBuffer;
import io.homo.superresolution.core.graphics.impl.pipeline.IPipelineJob;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import java.util.Objects;
import org.joml.Vector4i;

public class PipelineCopyTextureJob
implements IPipelineJob {
    protected Vector4i sourceDimensions;
    protected Vector4i destinationDimensions;
    protected ITexture source;
    protected ITexture destination;

    public PipelineCopyTextureJob(ITexture source, ITexture destination, Vector4i sourceDimensions, Vector4i destinationDimensions) {
        this.source = Objects.requireNonNull(source, "\u6e90\u7eb9\u7406\u4e0d\u80fd\u4e3anull");
        this.destination = Objects.requireNonNull(destination, "\u76ee\u6807\u7eb9\u7406\u4e0d\u80fd\u4e3anull");
        if (sourceDimensions == null && destinationDimensions == null) {
            if (source.getWidth() != destination.getWidth() || source.getHeight() != destination.getHeight()) {
                throw new RuntimeException("\u590d\u5236\u533a\u57df\u672a\u6307\u5b9a\uff0c\u9ed8\u8ba4\u590d\u5236\u5168\u7eb9\u7406\uff0c\u6e90\u7eb9\u7406\u4e0e\u76ee\u6807\u7eb9\u7406\u5927\u5c0f\u4e0d\u540c");
            }
        } else {
            this.validateDimensions(sourceDimensions, "\u6e90");
            this.validateDimensions(destinationDimensions, "\u76ee\u6807");
        }
        this.sourceDimensions = sourceDimensions;
        this.destinationDimensions = destinationDimensions;
        if (!source.getTextureFormat().equals((Object)destination.getTextureFormat())) {
            throw new IllegalArgumentException("\u7eb9\u7406\u683c\u5f0f\u4e0d\u517c\u5bb9");
        }
    }

    private void validateDimensions(Vector4i dim, String name) {
        Objects.requireNonNull(dim, name + "\u7ef4\u5ea6\u4e0d\u80fd\u4e3anull");
        if (dim.x < 0 || dim.y < 0 || dim.z <= 0 || dim.w <= 0) {
            throw new IllegalArgumentException(name + "\u7ef4\u5ea6\u65e0\u6548: " + String.valueOf(dim));
        }
    }

    @Override
    public void execute(ICommandBuffer commandBuffer) {
        if (this.sourceDimensions == null && this.destinationDimensions == null) {
            if (this.source.getWidth() != this.destination.getWidth() || this.source.getHeight() != this.destination.getHeight()) {
                throw new RuntimeException("\u590d\u5236\u533a\u57df\u672a\u6307\u5b9a\uff0c\u9ed8\u8ba4\u590d\u5236\u5168\u7eb9\u7406\uff0c\u6e90\u7eb9\u7406\u4e0e\u76ee\u6807\u7eb9\u7406\u5927\u5c0f\u4e0d\u540c");
            }
            commandBuffer.getEncoder().copyTexture(commandBuffer, this.source, this.destination, 0, 0, this.source.getWidth(), this.source.getHeight(), 0, 0, 0, this.destination.getWidth(), this.destination.getHeight(), 0);
        } else {
            this.checkBounds(this.source, this.sourceDimensions, "\u6e90");
            this.checkBounds(this.destination, this.destinationDimensions, "\u76ee\u6807");
            commandBuffer.getEncoder().copyTexture(commandBuffer, this.source, this.destination, this.sourceDimensions.x, this.sourceDimensions.y, this.sourceDimensions.z, this.sourceDimensions.w, 0, this.destinationDimensions.x, this.destinationDimensions.y, this.destinationDimensions.z, this.destinationDimensions.w, 0);
        }
    }

    private void checkTextureFormat() {
        if (this.source.getTextureFormat() != this.destination.getTextureFormat()) {
            throw new IllegalArgumentException("\u6e90\u7eb9\u7406\u4e0e\u76ee\u6807\u7eb9\u7406\u683c\u5f0f\u4e0d\u540c %s %s".formatted(new Object[]{this.source.getTextureFormat(), this.destination.getTextureFormat()}));
        }
    }

    private void checkBounds(ITexture tex, Vector4i dim, String name) {
        if (dim.x + dim.z > tex.getWidth() || dim.y + dim.w > tex.getHeight()) {
            throw new IllegalArgumentException(name + "\u590d\u5236\u533a\u57df\u8d85\u51fa\u7eb9\u7406\u8fb9\u754c");
        }
    }

    @Override
    public void destroy() {
        this.source = null;
        this.destination = null;
    }
}

