/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.opengl.shader.uniform;

import io.homo.superresolution.core.graphics.impl.shader.ShaderDescription;
import io.homo.superresolution.core.graphics.impl.shader.uniform.IShaderUniform;
import io.homo.superresolution.core.graphics.impl.shader.uniform.ShaderUniformType;
import io.homo.superresolution.core.graphics.impl.shader.uniform.ShaderUniforms;
import io.homo.superresolution.core.graphics.opengl.shader.GlShaderProgram;
import io.homo.superresolution.core.graphics.opengl.shader.uniform.GlShaderBaseUniform;
import io.homo.superresolution.core.graphics.opengl.shader.uniform.GlShaderUniformBuffer;
import io.homo.superresolution.core.graphics.opengl.shader.uniform.GlShaderUniformSamplerTexture;
import io.homo.superresolution.core.graphics.opengl.shader.uniform.GlShaderUniformStorageTexture;
import io.homo.superresolution.core.impl.Destroyable;
import java.util.HashMap;
import java.util.Map;

public class GlShaderUniforms
extends ShaderUniforms<GlShaderUniforms, GlShaderProgram, GlShaderUniformBuffer, GlShaderUniformSamplerTexture, GlShaderUniformStorageTexture> {
    private final Map<String, GlShaderBaseUniform<?, ?>> uniformMap = new HashMap();

    public GlShaderUniforms(GlShaderProgram program, ShaderDescription description) {
        super(program, description);
        description.shaderUniforms().values().forEach(uniformDescription -> {
            String string = uniformDescription.name();
            this.uniformMap.put(string, switch (uniformDescription.type()) {
                default -> throw new MatchException(null, null);
                case ShaderUniformType.UniformBuffer -> new GlShaderUniformBuffer(uniformDescription.name(), uniformDescription.binding(), uniformDescription.access());
                case ShaderUniformType.SamplerTexture -> new GlShaderUniformSamplerTexture(uniformDescription.name(), uniformDescription.binding(), uniformDescription.access());
                case ShaderUniformType.StorageTexture -> new GlShaderUniformStorageTexture(uniformDescription.name(), uniformDescription.binding(), uniformDescription.access());
            });
        });
    }

    @Override
    public GlShaderUniformBuffer uniformBuffer(String name) {
        GlShaderBaseUniform<?, ?> uniform = this.uniformMap.get(name);
        if (!(uniform instanceof GlShaderUniformBuffer)) {
            throw new ClassCastException("Uniform " + name + " \u4e0d\u662fUBO\u7c7b\u578b");
        }
        return (GlShaderUniformBuffer)uniform;
    }

    @Override
    public GlShaderUniformSamplerTexture samplerTexture(String name) {
        GlShaderBaseUniform<?, ?> uniform = this.uniformMap.get(name);
        if (!(uniform instanceof GlShaderUniformSamplerTexture)) {
            throw new ClassCastException("Uniform " + name + " \u4e0d\u662f\u91c7\u6837\u7eb9\u7406\u7c7b\u578b");
        }
        return (GlShaderUniformSamplerTexture)uniform;
    }

    @Override
    public GlShaderUniformStorageTexture storageTexture(String name) {
        GlShaderBaseUniform<?, ?> uniform = this.uniformMap.get(name);
        if (!(uniform instanceof GlShaderUniformStorageTexture)) {
            throw new ClassCastException("Uniform " + name + " \u4e0d\u662f\u5b58\u50a8\u7eb9\u7406\u7c7b\u578b");
        }
        return (GlShaderUniformStorageTexture)uniform;
    }

    @Override
    public IShaderUniform<?, ?> get(String name) {
        return this.uniformMap.get(name);
    }

    public Map<String, GlShaderBaseUniform<?, ?>> getUniformMap() {
        return this.uniformMap;
    }

    @Override
    public void destroy() {
        this.uniformMap.values().forEach(Destroyable::destroy);
    }
}

