/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.vulkan;

import io.homo.superresolution.api.platform.OperatingSystemType;
import io.homo.superresolution.api.platform.Platform;
import io.homo.superresolution.core.graphics.vulkan.utils.VulkanUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.EXTMemoryObjectFD;
import org.lwjgl.opengl.EXTMemoryObjectWin32;
import org.lwjgl.opengl.EXTSemaphoreFD;
import org.lwjgl.opengl.EXTSemaphoreWin32;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.Struct;
import org.lwjgl.vulkan.KHRExternalMemoryFd;
import org.lwjgl.vulkan.KHRExternalMemoryWin32;
import org.lwjgl.vulkan.KHRExternalSemaphoreFd;
import org.lwjgl.vulkan.KHRExternalSemaphoreWin32;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkExportMemoryAllocateInfo;
import org.lwjgl.vulkan.VkExportSemaphoreCreateInfo;
import org.lwjgl.vulkan.VkImportMemoryFdInfoKHR;
import org.lwjgl.vulkan.VkImportMemoryWin32HandleInfoKHR;
import org.lwjgl.vulkan.VkMemoryGetFdInfoKHR;
import org.lwjgl.vulkan.VkMemoryGetWin32HandleInfoKHR;
import org.lwjgl.vulkan.VkSemaphoreGetFdInfoKHR;
import org.lwjgl.vulkan.VkSemaphoreGetWin32HandleInfoKHR;

public class VulkanInterop {
    public static final VulkanInteropExt IMPL = Platform.currentPlatform.getOS().type == OperatingSystemType.WINDOWS ? new WindowsVulkanInteropExtImpl() : new LinuxVulkanInteropExtImpl();

    private static class WindowsVulkanInteropExtImpl
    implements VulkanInteropExt {
        private WindowsVulkanInteropExtImpl() {
        }

        @Override
        public void glImportMemoryEXT(int memoryObject, long size, long handle) {
            EXTMemoryObjectWin32.glImportMemoryWin32HandleEXT((int)memoryObject, (long)size, (int)38279, (long)handle);
        }

        @Override
        public void glImportSemaphoreHandleEXT(MemoryStack stack, int semaphore, long handle) {
            EXTSemaphoreWin32.glImportSemaphoreWin32HandleEXT((int)semaphore, (int)38279, (long)((int)handle));
        }

        @Override
        public long vkGetSemaphoreHandleKHR(MemoryStack stack, VkDevice device, Struct pGetHandleInfo) {
            PointerBuffer fd = stack.callocPointer(1);
            KHRExternalSemaphoreWin32.vkGetSemaphoreWin32HandleKHR((VkDevice)device, (VkSemaphoreGetWin32HandleInfoKHR)((VkSemaphoreGetWin32HandleInfoKHR)pGetHandleInfo), (PointerBuffer)fd);
            return fd.get(0);
        }

        @Override
        public Struct createVkSemaphoreGetHandleInfoKHR(MemoryStack stack, long pVkSemaphore) {
            VkSemaphoreGetWin32HandleInfoKHR semaphoreGetInfo = VkSemaphoreGetWin32HandleInfoKHR.calloc((MemoryStack)stack);
            semaphoreGetInfo.sType(1000078003);
            semaphoreGetInfo.handleType(2);
            semaphoreGetInfo.semaphore(pVkSemaphore);
            return semaphoreGetInfo;
        }

        @Override
        public Struct createVkExportSemaphoreCreateInfo(MemoryStack stack) {
            VkExportSemaphoreCreateInfo exportSemaphoreCreateInfo = VkExportSemaphoreCreateInfo.calloc((MemoryStack)stack);
            exportSemaphoreCreateInfo.sType(1000077000);
            exportSemaphoreCreateInfo.handleTypes(2);
            return exportSemaphoreCreateInfo;
        }

        @Override
        public Struct createVkExportMemoryAllocateInfo(MemoryStack stack) {
            return VkExportMemoryAllocateInfo.calloc((MemoryStack)stack).sType(1000072002).handleTypes(2);
        }

        @Override
        public Struct createVkImportMemoryInfo(MemoryStack stack, long handle) {
            return VkImportMemoryWin32HandleInfoKHR.calloc((MemoryStack)stack).sType(1000073000).handleType(2).handle(handle);
        }

        @Override
        public long vkGetMemoryHandle(MemoryStack stack, VkDevice device, long memory) {
            VkMemoryGetWin32HandleInfoKHR getInfo = VkMemoryGetWin32HandleInfoKHR.calloc((MemoryStack)stack).sType(1000073003).memory(memory).handleType(2);
            PointerBuffer pHandle = stack.mallocPointer(1);
            VulkanUtils.VK_CHECK(KHRExternalMemoryWin32.vkGetMemoryWin32HandleKHR((VkDevice)device, (VkMemoryGetWin32HandleInfoKHR)getInfo, (PointerBuffer)pHandle), "Failed to export Windows memory handle");
            return pHandle.get(0);
        }
    }

    public static interface VulkanInteropExt {
        public void glImportSemaphoreHandleEXT(MemoryStack var1, int var2, long var3);

        public long vkGetSemaphoreHandleKHR(MemoryStack var1, VkDevice var2, Struct var3);

        public Struct createVkSemaphoreGetHandleInfoKHR(MemoryStack var1, long var2);

        public Struct createVkExportSemaphoreCreateInfo(MemoryStack var1);

        public Struct createVkExportMemoryAllocateInfo(MemoryStack var1);

        public Struct createVkImportMemoryInfo(MemoryStack var1, long var2);

        public long vkGetMemoryHandle(MemoryStack var1, VkDevice var2, long var3);

        public void glImportMemoryEXT(int var1, long var2, long var4);
    }

    private static class LinuxVulkanInteropExtImpl
    implements VulkanInteropExt {
        private LinuxVulkanInteropExtImpl() {
        }

        @Override
        public void glImportMemoryEXT(int memoryObject, long size, long handle) {
            EXTMemoryObjectFD.glImportMemoryFdEXT((int)memoryObject, (long)size, (int)38278, (int)((int)handle));
        }

        @Override
        public void glImportSemaphoreHandleEXT(MemoryStack stack, int semaphore, long handle) {
            EXTSemaphoreFD.glImportSemaphoreFdEXT((int)semaphore, (int)38278, (int)((int)handle));
        }

        @Override
        public long vkGetSemaphoreHandleKHR(MemoryStack stack, VkDevice device, Struct pGetHandleInfo) {
            int[] fd = new int[]{0};
            KHRExternalSemaphoreFd.vkGetSemaphoreFdKHR((VkDevice)device, (VkSemaphoreGetFdInfoKHR)((VkSemaphoreGetFdInfoKHR)pGetHandleInfo), (int[])fd);
            return fd[0];
        }

        @Override
        public Struct createVkSemaphoreGetHandleInfoKHR(MemoryStack stack, long pVkSemaphore) {
            VkSemaphoreGetFdInfoKHR semaphoreGetInfo = VkSemaphoreGetFdInfoKHR.calloc((MemoryStack)stack);
            semaphoreGetInfo.sType(1000079001);
            semaphoreGetInfo.handleType(1);
            semaphoreGetInfo.semaphore(pVkSemaphore);
            return semaphoreGetInfo;
        }

        @Override
        public Struct createVkExportSemaphoreCreateInfo(MemoryStack stack) {
            VkExportSemaphoreCreateInfo exportSemaphoreCreateInfo = VkExportSemaphoreCreateInfo.calloc((MemoryStack)stack);
            exportSemaphoreCreateInfo.sType(1000077000);
            exportSemaphoreCreateInfo.handleTypes(1);
            return exportSemaphoreCreateInfo;
        }

        @Override
        public Struct createVkExportMemoryAllocateInfo(MemoryStack stack) {
            return VkExportMemoryAllocateInfo.calloc((MemoryStack)stack).sType(1000072002).handleTypes(1);
        }

        @Override
        public Struct createVkImportMemoryInfo(MemoryStack stack, long handle) {
            return VkImportMemoryFdInfoKHR.calloc((MemoryStack)stack).sType(1000074000).handleType(1).fd((int)handle);
        }

        @Override
        public long vkGetMemoryHandle(MemoryStack stack, VkDevice device, long memory) {
            VkMemoryGetFdInfoKHR getInfo = VkMemoryGetFdInfoKHR.calloc((MemoryStack)stack).sType(1000074002).memory(memory).handleType(1);
            int[] fd = new int[1];
            VulkanUtils.VK_CHECK(KHRExternalMemoryFd.vkGetMemoryFdKHR((VkDevice)device, (VkMemoryGetFdInfoKHR)getInfo, (int[])fd), "Failed to export Linux memory handle");
            return fd[0];
        }
    }
}

