/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.core;

import io.homo.superresolution.core.gui.core.IScrollHandler;
import io.homo.superresolution.core.math.MathUtil;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class SmoothDragScrollHandler
implements IScrollHandler {
    private Vector2f offset = new Vector2f();
    private Vector2f targetOffset = new Vector2f();
    private Vector2f velocity = new Vector2f();
    private IScrollHandler.OnOffsetChangedListener listener;
    private Vector2f minOffset = new Vector2f(Float.NEGATIVE_INFINITY);
    private Vector2f maxOffset = new Vector2f(Float.POSITIVE_INFINITY);
    private boolean enableBounds = false;
    private boolean dragging = false;
    private float smoothTime = 1.45f;
    private float scrollStep = 30.0f;

    public SmoothDragScrollHandler(IScrollHandler.OnOffsetChangedListener listener) {
        this.listener = listener;
    }

    @Override
    public void onDragStart(Vector2f pos) {
        this.dragging = true;
    }

    @Override
    public void onDragMove(Vector2f pos, Vector2f delta) {
        if (this.dragging) {
            this.scrollBy(delta.mul(-1.5f));
        }
    }

    @Override
    public void onDragEnd(Vector2f pos) {
        this.dragging = false;
    }

    @Override
    public void onScroll(float deltaX, float deltaY) {
        this.targetOffset.add(deltaX * this.scrollStep, -deltaY * this.scrollStep);
        this.applyBoundsToTarget();
    }

    @Override
    public void scrollTo(Vector2f target) {
        this.targetOffset.set((Vector2fc)target);
        this.applyBoundsToTarget();
    }

    @Override
    public void setScroll(Vector2f target) {
        this.offset.set((Vector2fc)target);
        this.targetOffset.set((Vector2fc)target);
        this.notifyOffset();
    }

    @Override
    public void scrollBy(Vector2f delta) {
        this.targetOffset.add((Vector2fc)delta);
        this.applyBoundsToTarget();
    }

    @Override
    public void update(float deltaTime) {
        float factor = 1.0f - (float)Math.exp(-deltaTime / this.smoothTime);
        this.offset.lerp((Vector2fc)this.targetOffset, factor);
        this.notifyOffset();
    }

    @Override
    public void stop() {
        this.velocity.zero();
    }

    @Override
    public Vector2f getCurrentOffset() {
        return new Vector2f((Vector2fc)this.offset);
    }

    @Override
    public void setOnOffsetChanged(IScrollHandler.OnOffsetChangedListener listener) {
        this.listener = listener;
    }

    @Override
    public void setScrollBounds(Vector2f min, Vector2f max) {
        this.minOffset.set((Vector2fc)min);
        this.maxOffset.set((Vector2fc)max);
        this.enableBounds = true;
        this.applyBoundsToTarget();
        this.applyBoundsToOffset();
    }

    @Override
    public void clearScrollBounds() {
        this.enableBounds = false;
        this.minOffset.set(Float.NEGATIVE_INFINITY);
        this.maxOffset.set(Float.POSITIVE_INFINITY);
    }

    private void applyBoundsToTarget() {
        if (this.enableBounds) {
            this.targetOffset = MathUtil.clamp(this.targetOffset, this.minOffset, this.maxOffset);
        }
    }

    private void applyBoundsToOffset() {
        if (this.enableBounds) {
            this.offset = MathUtil.clamp(this.offset, this.minOffset, this.maxOffset);
        }
    }

    private void notifyOffset() {
        if (this.listener != null) {
            this.listener.onOffsetChanged(new Vector2f((Vector2fc)this.offset));
        }
    }
}

