/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.core.layout;

import io.homo.superresolution.core.gui.core.IHitTest;
import io.homo.superresolution.core.gui.core.impl.Rectangle;
import io.homo.superresolution.core.gui.core.layout.ILayoutContainer;
import io.homo.superresolution.core.gui.core.layout.ILayoutElement;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaNode;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaProps;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.config.MutableYogaConfig;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.config.YogaConfig;
import org.joml.Vector2f;

public abstract class AbstractLayoutElement
implements ILayoutElement,
IHitTest {
    public static final MutableYogaConfig yogaConfig = YogaConfig.create();
    private final Vector2f elementSize = new Vector2f(-1.0f, -1.0f);
    protected ILayoutContainer parent;
    private YogaNode layoutNode = new YogaNode(yogaConfig);

    public void setElementSize(float width, float height) {
        this.elementSize.set(width, height);
        if (width > 0.0f) {
            this.layoutNode.setWidth(width);
        }
        if (height > 0.0f) {
            this.layoutNode.setHeight(height);
        }
    }

    public void setElementWidth(float width) {
        this.setElementSize(width, this.elementSize.y);
    }

    public void setElementHeight(float height) {
        this.setElementSize(this.elementSize.x, height);
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.getAbsolutePosition(), this.elementSize.x <= 0.0f || this.elementSize.y <= 0.0f ? new Vector2f(this.layoutNode.getLayoutWidth(), this.layoutNode.getLayoutHeight()) : this.elementSize);
    }

    @Override
    public Vector2f getAbsolutePosition() {
        return new Vector2f(this.getLayoutNode().getAbsolutePositionX(), this.getLayoutNode().getAbsolutePositionY());
    }

    @Override
    public ILayoutContainer getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ILayoutContainer parent) {
        this.parent = parent;
    }

    @Override
    public boolean hitTest(Vector2f absolutePos) {
        Rectangle absBounds = this.getBounds();
        boolean result = absBounds.in(absolutePos);
        return result;
    }

    @Override
    public YogaNode getLayoutNode() {
        return this.layoutNode;
    }

    @Override
    public YogaProps layout() {
        return this.layoutNode;
    }
}

