// Copyright  © 2023 Advanced Micro Devices, Inc.
// Copyright  © 2024-2025 Arm Limited.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef FFXM_FSR2_RESOURCES_H
#define FFXM_FSR2_RESOURCES_H

#if defined(FFXM_CPU) || defined(FFXM_GPU)
#define FFXM_FSR2_RESOURCE_IDENTIFIER_NULL                                           0
#define FFXM_FSR2_RESOURCE_IDENTIFIER_INPUT_OPAQUE_ONLY                              1
#define FFXM_FSR2_RESOURCE_IDENTIFIER_INPUT_COLOR                                    2
#define FFXM_FSR2_RESOURCE_IDENTIFIER_INPUT_MOTION_VECTORS                           3
#define FFXM_FSR2_RESOURCE_IDENTIFIER_INPUT_DEPTH                                    4
#define FFXM_FSR2_RESOURCE_IDENTIFIER_INPUT_EXPOSURE                                 5
#define FFXM_FSR2_RESOURCE_IDENTIFIER_INPUT_REACTIVE_MASK                            6
#define FFXM_FSR2_RESOURCE_IDENTIFIER_INPUT_TRANSPARENCY_AND_COMPOSITION_MASK        7
#define FFXM_FSR2_RESOURCE_IDENTIFIER_RECONSTRUCTED_PREVIOUS_NEAREST_DEPTH           8
#define FFXM_FSR2_RESOURCE_IDENTIFIER_DILATED_MOTION_VECTORS                         9
#define FFXM_FSR2_RESOURCE_IDENTIFIER_DILATED_DEPTH                                  10
#define FFXM_FSR2_RESOURCE_IDENTIFIER_INTERNAL_UPSCALED_COLOR                        11
#define FFXM_FSR2_RESOURCE_IDENTIFIER_LOCK_STATUS                                    12
#define FFXM_FSR2_RESOURCE_IDENTIFIER_NEW_LOCKS                                      13
#define FFXM_FSR2_RESOURCE_IDENTIFIER_PREPARED_INPUT_COLOR                           14
#define FFXM_FSR2_RESOURCE_IDENTIFIER_LUMA_HISTORY                                   15
#define FFXM_FSR2_RESOURCE_IDENTIFIER_DEBUG_OUTPUT                                   16
#define FFXM_FSR2_RESOURCE_IDENTIFIER_LANCZOS_LUT                                    17
#define FFXM_FSR2_RESOURCE_IDENTIFIER_SPD_ATOMIC_COUNT                               18
#define FFXM_FSR2_RESOURCE_IDENTIFIER_UPSCALED_OUTPUT                                19
#define FFXM_FSR2_RESOURCE_IDENTIFIER_RCAS_INPUT                                     20
#define FFXM_FSR2_RESOURCE_IDENTIFIER_LOCK_STATUS_1                                  21
#define FFXM_FSR2_RESOURCE_IDENTIFIER_LOCK_STATUS_2                                  22
#define FFXM_FSR2_RESOURCE_IDENTIFIER_INTERNAL_UPSCALED_COLOR_1                      23
#define FFXM_FSR2_RESOURCE_IDENTIFIER_INTERNAL_UPSCALED_COLOR_2                      24
#define FFXM_FSR2_RESOURCE_IDENTIFIER_INTERNAL_DEFAULT_REACTIVITY                    25
#define FFXM_FSR2_RESOURCE_IDENTIFIER_INTERNAL_DEFAULT_TRANSPARENCY_AND_COMPOSITION  26
#define FFXM_FSR2_RESOURCE_IDENTITIER_UPSAMPLE_MAXIMUM_BIAS_LUT                      27
#define FFXM_FSR2_RESOURCE_IDENTIFIER_DILATED_REACTIVE_MASKS                         28
#define FFXM_FSR2_RESOURCE_IDENTIFIER_SCENE_LUMINANCE                                29 // same as FFXM_FSR2_RESOURCE_IDENTIFIER_SCENE_LUMINANCE_MIPMAP_0
#define FFXM_FSR2_RESOURCE_IDENTIFIER_SCENE_LUMINANCE_MIPMAP_0                       29
#define FFXM_FSR2_RESOURCE_IDENTIFIER_SCENE_LUMINANCE_MIPMAP_1                       30
#define FFXM_FSR2_RESOURCE_IDENTIFIER_SCENE_LUMINANCE_MIPMAP_2                       31
#define FFXM_FSR2_RESOURCE_IDENTIFIER_SCENE_LUMINANCE_MIPMAP_3                       32
#define FFXM_FSR2_RESOURCE_IDENTIFIER_SCENE_LUMINANCE_MIPMAP_4                       33
#define FFXM_FSR2_RESOURCE_IDENTIFIER_SCENE_LUMINANCE_MIPMAP_5                       34
#define FFXM_FSR2_RESOURCE_IDENTIFIER_SCENE_LUMINANCE_MIPMAP_6                       35
#define FFXM_FSR2_RESOURCE_IDENTIFIER_SCENE_LUMINANCE_MIPMAP_7                       36
#define FFXM_FSR2_RESOURCE_IDENTIFIER_SCENE_LUMINANCE_MIPMAP_8                       37
#define FFXM_FSR2_RESOURCE_IDENTIFIER_SCENE_LUMINANCE_MIPMAP_9                       38
#define FFXM_FSR2_RESOURCE_IDENTIFIER_SCENE_LUMINANCE_MIPMAP_10                      39
#define FFXM_FSR2_RESOURCE_IDENTIFIER_SCENE_LUMINANCE_MIPMAP_11                      40
#define FFXM_FSR2_RESOURCE_IDENTIFIER_SCENE_LUMINANCE_MIPMAP_12                      41
#define FFXM_FSR2_RESOURCE_IDENTIFIER_INTERNAL_DEFAULT_EXPOSURE                      42
#define FFXM_FSR2_RESOURCE_IDENTIFIER_AUTO_EXPOSURE                                  43
#define FFXM_FSR2_RESOURCE_IDENTIFIER_AUTOREACTIVE                                   44
#define FFXM_FSR2_RESOURCE_IDENTIFIER_PREVIOUS_DILATED_MOTION_VECTORS                45
#define FFXM_FSR2_RESOURCE_IDENTIFIER_INTERNAL_DILATED_MOTION_VECTORS_1              46
#define FFXM_FSR2_RESOURCE_IDENTIFIER_INTERNAL_DILATED_MOTION_VECTORS_2              47
#define FFXM_FSR2_RESOURCE_IDENTIFIER_LUMA_HISTORY_1                                 48
#define FFXM_FSR2_RESOURCE_IDENTIFIER_LUMA_HISTORY_2                                 49
#define FFXM_FSR2_RESOURCE_IDENTIFIER_LOCK_INPUT_LUMA                                50
#define FFXM_FSR2_RESOURCE_IDENTIFIER_INTERNAL_TEMPORAL_REACTIVE				     51
#define FFXM_FSR2_RESOURCE_IDENTIFIER_INTERNAL_TEMPORAL_REACTIVE_1					 52
#define FFXM_FSR2_RESOURCE_IDENTIFIER_INTERNAL_TEMPORAL_REACTIVE_2					 53
#define FFXM_FSR2_RESOURCE_IDENTIFIER_DILATED_DEPTH_MOTION_VECTORS_INPUT_LUMA        54
#define FFXM_FSR2_RESOURCE_IDENTIFIER_PREV_DILATED_DEPTH_MOTION_VECTORS_INPUT_LUMA   55
#define FFXM_FSR2_RESOURCE_IDENTIFIER_DILATED_DEPTH_MOTION_VECTORS_INPUT_LUMA_1      56
#define FFXM_FSR2_RESOURCE_IDENTIFIER_DILATED_DEPTH_MOTION_VECTORS_INPUT_LUMA_2      57

// Shading change detection mip level setting, value must be in the range [FFXM_FSR2_RESOURCE_IDENTIFIER_SCENE_LUMINANCE_MIPMAP_0, FFXM_FSR2_RESOURCE_IDENTIFIER_SCENE_LUMINANCE_MIPMAP_12]
#define FFXM_FSR2_RESOURCE_IDENTIFIER_SCENE_LUMINANCE_MIPMAP_SHADING_CHANGE          FFXM_FSR2_RESOURCE_IDENTIFIER_SCENE_LUMINANCE_MIPMAP_4
#define FFXM_FSR2_SHADING_CHANGE_MIP_LEVEL                                           (FFXM_FSR2_RESOURCE_IDENTIFIER_SCENE_LUMINANCE_MIPMAP_SHADING_CHANGE - FFXM_FSR2_RESOURCE_IDENTIFIER_SCENE_LUMINANCE)

#define FFXM_FSR2_RESOURCE_IDENTIFIER_COUNT                                          58

#define FFXM_FSR2_CONSTANTBUFFER_IDENTIFIER_FSR2                                     0
#define FFXM_FSR2_CONSTANTBUFFER_IDENTIFIER_SPD                                      1
#define FFXM_FSR2_CONSTANTBUFFER_IDENTIFIER_RCAS                                     2
#define FFXM_FSR2_CONSTANTBUFFER_IDENTIFIER_GENREACTIVE                              3

#define FFXM_FSR2_AUTOREACTIVEFLAGS_APPLY_TONEMAP                                    1
#define FFXM_FSR2_AUTOREACTIVEFLAGS_APPLY_INVERSETONEMAP                             2
#define FFXM_FSR2_AUTOREACTIVEFLAGS_APPLY_THRESHOLD                                  4
#define FFXM_FSR2_AUTOREACTIVEFLAGS_USE_COMPONENTS_MAX                               8

#endif // #if defined(FFXM_CPU) || defined(FFXM_GPU)

#endif //!defined( FFXM_FSR2_RESOURCES_H )
