/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft;

import com.mojang.blaze3d.pipeline.RenderTarget;
import io.homo.superresolution.core.gl.Gl;
import io.homo.superresolution.core.gl.framebuffer.GlFrameBuffer;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferTextureAdapter;
import io.homo.superresolution.core.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.impl.texture.ITexture;
import io.homo.superresolution.core.impl.texture.TextureFormat;
import io.homo.superresolution.core.utils.ColorUtil;
import net.minecraft.client.Minecraft;

public class MinecraftRenderTargetWrapper
implements IFrameBuffer {
    public RenderTarget renderTarget;
    private int clearColor = ColorUtil.color(255, 0, 0, 0);

    MinecraftRenderTargetWrapper(RenderTarget renderTarget) {
        this.renderTarget = renderTarget;
    }

    public static MinecraftRenderTargetWrapper of(RenderTarget renderTarget) {
        if (renderTarget == null) {
            return null;
        }
        MinecraftRenderTargetWrapper wrapper = new MinecraftRenderTargetWrapper(renderTarget);
        wrapper.clearColor = ColorUtil.color(255, 0, 0, 0);
        return wrapper;
    }

    @Override
    public void clearFrameBuffer() {
        this.renderTarget.m_83954_(Minecraft.f_91002_);
    }

    @Override
    public void resizeFrameBuffer(int width, int height) {
        this.renderTarget.m_83941_(width, height, Minecraft.f_91002_);
    }

    @Override
    public int getWidth() {
        return this.renderTarget.f_83915_;
    }

    @Override
    public int getHeight() {
        return this.renderTarget.f_83916_;
    }

    @Override
    public void destroy() {
        this.renderTarget.m_83930_();
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint, boolean setViewport) {
        if (bindPoint == FrameBufferBindPoint.READ) {
            this.renderTarget.m_83956_();
        } else {
            this.renderTarget.m_83947_(setViewport);
        }
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint) {
        this.bind(bindPoint, true);
    }

    @Override
    public void unbind(FrameBufferBindPoint bindPoint) {
        Gl.glBindFramebuffer(GlFrameBuffer.resolveBindTarget(bindPoint), 0);
    }

    @Override
    public int getTextureId(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new IncompatibleClassChangeError();
            case FrameBufferAttachmentType.COLOR -> this.renderTarget.m_83975_();
            case FrameBufferAttachmentType.ANY_DEPTH, FrameBufferAttachmentType.DEPTH, FrameBufferAttachmentType.DEPTH_STENCIL -> this.renderTarget.m_83980_();
        };
    }

    @Override
    public ITexture getTexture(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new IncompatibleClassChangeError();
            case FrameBufferAttachmentType.COLOR -> FrameBufferTextureAdapter.ofColor(this);
            case FrameBufferAttachmentType.ANY_DEPTH, FrameBufferAttachmentType.DEPTH, FrameBufferAttachmentType.DEPTH_STENCIL -> FrameBufferTextureAdapter.ofDepth(this);
        };
    }

    @Override
    public int getFrameBufferId() {
        return this.renderTarget.f_83920_;
    }

    @Override
    public void m_83931_(float red, float green, float blue, float alpha) {
        this.renderTarget.m_83931_(red, green, blue, alpha);
    }

    @Override
    public TextureFormat getColorTextureFormat() {
        return TextureFormat.RGBA8;
    }

    @Override
    public TextureFormat getDepthTextureFormat() {
        return TextureFormat.DEPTH24;
    }

    @Override
    public RenderTarget asMcRenderTarget() {
        return this.renderTarget;
    }
}

