/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.mixin.core;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.config.Config;
import io.homo.superresolution.common.minecraft.MinecraftRenderHandle;
import io.homo.superresolution.common.mixin.core.accessor.PostChainAccessor;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PostChain.class})
public abstract class PostChainMixin {
    @Shadow
    @Final
    private List<PostPass> f_110009_;
    @Shadow
    @Final
    private Map<String, RenderTarget> f_110010_;
    @Shadow
    @Final
    private RenderTarget f_110006_;
    @Shadow
    @Final
    private String f_110008_;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void onInitPostChain(TextureManager textureManager, ResourceManager resourceManager, RenderTarget screenTarget, ResourceLocation name, CallbackInfo ci) throws IOException, JsonSyntaxException {
        if (this.onBlackList()) {
            return;
        }
        if (!screenTarget.equals(MinecraftRenderHandle.getOriginRenderTarget().asMcRenderTarget())) {
            return;
        }
        this.f_110009_.forEach(PostPass::close);
        this.f_110009_.clear();
        this.f_110010_.values().forEach(RenderTarget::m_83930_);
        this.f_110010_.clear();
        ((PostChainAccessor)((Object)this)).setScreenTarget(MinecraftRenderHandle.getRenderTarget().asMcRenderTarget());
        this.m_110046_();
        this.m_110033_(textureManager, name);
        SuperResolution.LOGGER.info("\u5df2\u6ce8\u5165PostChain {}", (Object)this.f_110008_);
    }

    @Shadow
    public abstract void m_110025_(int var1, int var2);

    @Shadow
    protected abstract void m_110046_();

    @Shadow
    protected abstract void m_110033_(TextureManager var1, ResourceLocation var2) throws IOException, JsonSyntaxException;

    @Inject(method={"resize"}, at={@At(value="HEAD")}, cancellable=true)
    public void onResize(int width, int height, CallbackInfo ci) {
        if (this.onBlackList()) {
            return;
        }
        if (width != MinecraftRenderHandle.getRenderWidth() || height != MinecraftRenderHandle.getRenderHeight()) {
            this.m_110025_(MinecraftRenderHandle.getRenderWidth(), MinecraftRenderHandle.getRenderHeight());
            ci.cancel();
        }
    }

    @Inject(method={"process"}, at={@At(value="HEAD")})
    public void onProcess(float partialTicks, CallbackInfo ci) {
        if (this.onBlackList()) {
            return;
        }
        MinecraftRenderHandle.fixPostChain((PostChain)this);
    }

    private boolean onBlackList() {
        return Config.getInjectPostChainBlackList().contains(this.f_110008_);
    }
}

