/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.glslang;

import io.homo.superresolution.core.utils.FileReadHelper;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileIncluder {
    private static final String LOCAL_INCLUDE_BASE_PATH = "/shader/";
    private static final String SYSTEM_INCLUDE_BASE_PATH = "/shader/include/";

    public static String cppIncludeLocal(String headerName, String includerName, int inclusionDepth) {
        String resolvedPath = FileIncluder.resolveRelativePath(headerName, includerName);
        String fullPath = LOCAL_INCLUDE_BASE_PATH + resolvedPath;
        try {
            return String.join((CharSequence)"\n", FileReadHelper.readText(fullPath));
        }
        catch (Exception e) {
            return "// ERROR: include failed: " + fullPath;
        }
    }

    public static String cppIncludeSystem(String headerName, String includerName, int inclusionDepth) {
        String fullPath = SYSTEM_INCLUDE_BASE_PATH + headerName;
        try {
            return String.join((CharSequence)"\n", FileReadHelper.readText(fullPath));
        }
        catch (Exception e) {
            return "// ERROR: include failed: " + fullPath;
        }
    }

    private static String resolveRelativePath(String headerName, String includerName) {
        if (headerName.startsWith("/") || headerName.contains("/")) {
            return headerName;
        }
        if (includerName == null || includerName.isEmpty()) {
            return headerName;
        }
        Path base = Paths.get(includerName, new String[0]).getParent();
        if (base == null) {
            base = Paths.get("", new String[0]);
        }
        Path resolved = base.resolve(headerName).normalize();
        String rel = resolved.toString().replace("\\", "/");
        return rel;
    }
}

