/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.api.config;

import com.electronwill.nightconfig.core.ConfigSpec;
import io.homo.superresolution.api.config.ModConfigSpec;
import java.util.List;
import java.util.function.Supplier;

public abstract class ConfigValue<T> {
    protected final List<String> path;
    protected final Supplier<T> defaultSupplier;
    protected final String comment;
    protected ModConfigSpec configSpec;

    public ConfigValue(List<String> path, Supplier<T> defaultSupplier, String comment) {
        this.path = path;
        this.defaultSupplier = defaultSupplier;
        this.comment = comment;
    }

    public T get() {
        return this.convertType(this.configSpec.configData.getOrElse(this.path, this.defaultSupplier));
    }

    public void set(Object value) {
        if (!this.isValid(value)) {
            throw new IllegalArgumentException("Invalid value for config path " + String.valueOf(this.path) + ": " + String.valueOf(value));
        }
        this.configSpec.configData.set(this.path, value);
    }

    public T getDefault() {
        return this.defaultSupplier.get();
    }

    public List<String> getPath() {
        return this.path;
    }

    public String getComment() {
        return this.comment;
    }

    public abstract boolean isValid(Object var1);

    protected abstract void fillSpec(ConfigSpec var1);

    protected abstract T convertType(Object var1);
}

