/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.gui.entries;

import java.util.List;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;

public class ClothButtonEntry
extends AbstractConfigListEntry<Boolean> {
    private final Button button;
    private boolean fullSize;

    public ClothButtonEntry(Component name, Button.OnPress onPress, Vector2f size) {
        super(name, false);
        this.button = Button.builder((Component)name, (Button.OnPress)onPress).bounds(0, 0, (int)size.x, (int)size.y).build();
        this.fullSize = true;
    }

    public ClothButtonEntry(Component name, Button.OnPress onPress, boolean fullSize) {
        super(name, false);
        this.fullSize = fullSize;
        this.button = Button.builder((Component)name, (Button.OnPress)onPress).bounds(0, 0, 100, 20).build();
    }

    public ClothButtonEntry setFullSize(boolean fullSize) {
        this.fullSize = fullSize;
        return this;
    }

    @NotNull
    public List<? extends GuiEventListener> children() {
        return List.of(this.button);
    }

    public boolean isDragging() {
        return false;
    }

    public void setDragging(boolean b) {
    }

    @Nullable
    public GuiEventListener getFocused() {
        return null;
    }

    public void setFocused(@Nullable GuiEventListener guiEventListener) {
    }

    public List<? extends NarratableEntry> narratables() {
        return List.of(this.button);
    }

    public Boolean getValue() {
        return true;
    }

    public Optional<Boolean> getDefaultValue() {
        return Optional.of(true);
    }

    public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        this.button.setWidth(entryWidth);
        this.button.setHeight(entryHeight);
        this.button.setX(x + (entryWidth - this.button.getWidth()) / 2);
        this.button.setY(y);
        this.button.render(graphics, mouseX, mouseY, delta);
        super.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return null;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }
}

