/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.mixin.core;

import com.mojang.blaze3d.platform.Window;
import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.minecraft.handler.RenderHandlerManager;
import io.homo.superresolution.common.minecraft.handler.ShaderCompatHandler;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Window.class})
public class WindowMixin {
    @Shadow
    private int framebufferWidth;
    @Shadow
    private int framebufferHeight;

    @Inject(at={@At(value="RETURN")}, method={"getGuiScaledWidth"}, cancellable=true)
    private void getGuiScaledWidth(CallbackInfoReturnable<Integer> ci) {
        if (!ShaderCompatHandler.isShaderPackCompatSuperResolution()) {
            ci.setReturnValue((Object)this.super_resolution$clampSize((Integer)ci.getReturnValue()));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getGuiScaledHeight"}, cancellable=true)
    private void getGuiScaledHeight(CallbackInfoReturnable<Integer> ci) {
        if (!ShaderCompatHandler.isShaderPackCompatSuperResolution()) {
            ci.setReturnValue((Object)this.super_resolution$clampSize((Integer)ci.getReturnValue()));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getWidth"}, cancellable=true)
    private void getFramebufferWidth(CallbackInfoReturnable<Integer> ci) {
        if (!ShaderCompatHandler.isShaderPackCompatSuperResolution()) {
            ci.setReturnValue((Object)this.super_resolution$clampSize(this.super_resolution$scale((Integer)ci.getReturnValue())));
        }
    }

    @Unique
    private int super_resolution$clampSize(int size) {
        return Math.max(size, 1);
    }

    @Inject(at={@At(value="RETURN")}, method={"getHeight"}, cancellable=true)
    private void getFramebufferHeight(CallbackInfoReturnable<Integer> ci) {
        if (!ShaderCompatHandler.isShaderPackCompatSuperResolution()) {
            ci.setReturnValue((Object)this.super_resolution$clampSize(this.super_resolution$scale((Integer)ci.getReturnValue())));
        }
    }

    @Unique
    private int super_resolution$scale(int value) {
        double scaleFactor = RenderHandlerManager.getCurrentScaleFactor();
        return Math.max(Mth.ceil((double)((double)value * scaleFactor)), 1);
    }

    @Inject(at={@At(value="RETURN")}, method={"getGuiScale"}, cancellable=true)
    private void getScaleFactor(CallbackInfoReturnable<Integer> ci) {
        if (!ShaderCompatHandler.isShaderPackCompatSuperResolution()) {
            ci.setReturnValue((Object)((int)((float)((Integer)ci.getReturnValue()).intValue() * RenderHandlerManager.getCurrentScaleFactor())));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"onResize"})
    private void onFramebufferSizeChanged(CallbackInfo ci) {
        SuperResolution.framebufferWidth = this.framebufferWidth;
        SuperResolution.framebufferHeight = this.framebufferHeight;
        RenderHandlerManager.resize();
    }

    @Inject(at={@At(value="RETURN")}, method={"onFramebufferResize"})
    private void onUpdateFramebufferSize(CallbackInfo ci) {
        SuperResolution.framebufferWidth = this.framebufferWidth;
        SuperResolution.framebufferHeight = this.framebufferHeight;
        RenderHandlerManager.resize();
    }
}

