/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.opengl.dsa;

import io.homo.superresolution.core.graphics.GraphicsCapabilities;
import io.homo.superresolution.core.graphics.opengl.dsa.IGlDirectStateAccess;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengl.GL41;
import org.lwjgl.opengl.GL43;

public class CompatDirectStateAccessImpl
implements IGlDirectStateAccess {
    private final boolean gl43 = GraphicsCapabilities.getGLVersion()[0] >= 4 && GraphicsCapabilities.getGLVersion()[1] >= 3;

    @Override
    public void generateTextureMipmap(int texture) {
        int prevTex = GL41.glGetInteger((int)32873);
        GL41.glBindTexture((int)3553, (int)texture);
        GL41.glGenerateMipmap((int)3553);
        GL41.glBindTexture((int)3553, (int)prevTex);
    }

    @Override
    public int createSampler() {
        int[] samplers = new int[1];
        GL41.glGenSamplers((int[])samplers);
        return samplers[0];
    }

    @Override
    public void samplerParameteri(int sampler, int pname, int param) {
        GL41.glSamplerParameteri((int)sampler, (int)pname, (int)param);
    }

    @Override
    public void deleteSampler(int sampler) {
        GL41.glDeleteSamplers((int)sampler);
    }

    @Override
    public int createTextureView(int srcTexture, int target, int internalFormat, int minLevel, int numLevels, int minLayer, int numLayers) {
        int viewId = GL43.glGenTextures();
        GL43.glTextureView((int)viewId, (int)target, (int)srcTexture, (int)internalFormat, (int)minLevel, (int)numLevels, (int)minLayer, (int)numLayers);
        throw new UnsupportedOperationException("glTextureView not available in OpenGL 4.1");
    }

    @Override
    public void blitFramebuffer(int readFramebuffer, int drawFramebuffer, int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        int prevRead = GL41.glGetInteger((int)36010);
        int prevDraw = GL41.glGetInteger((int)36006);
        GL41.glBindFramebuffer((int)36008, (int)readFramebuffer);
        GL41.glBindFramebuffer((int)36009, (int)drawFramebuffer);
        GL41.glBlitFramebuffer((int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (int)mask, (int)filter);
        GL41.glBindFramebuffer((int)36008, (int)prevRead);
        GL41.glBindFramebuffer((int)36009, (int)prevDraw);
    }

    @Override
    public void clearFramebuffer(int framebuffer, int buffer, int drawbuffer, float[] value) {
        int prevFBO = GL41.glGetInteger((int)36006);
        GL41.glBindFramebuffer((int)36160, (int)framebuffer);
        switch (buffer) {
            case 6144: {
                GL41.glClearBufferfv((int)6144, (int)drawbuffer, (float[])value);
                break;
            }
            case 6145: {
                GL41.glClearBufferfv((int)6145, (int)0, (float[])value);
                break;
            }
            case 6146: {
                int[] ivalue = new int[]{(int)value[0]};
                GL41.glClearBufferiv((int)6146, (int)0, (int[])ivalue);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported buffer type");
            }
        }
        GL41.glBindFramebuffer((int)36160, (int)prevFBO);
    }

    @Override
    public void copyTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        int prevTex = GL41.glGetInteger((int)32873);
        GL41.glBindTexture((int)3553, (int)texture);
        GL41.glCopyTexSubImage2D((int)3553, (int)level, (int)xoffset, (int)yoffset, (int)x, (int)y, (int)width, (int)height);
        GL41.glBindTexture((int)3553, (int)prevTex);
    }

    @Override
    public void copyTextureSubImage1D(int texture, int level, int xoffset, int x, int y, int width) {
        int prevTex = GL41.glGetInteger((int)32872);
        GL41.glBindTexture((int)3552, (int)texture);
        GL41.glCopyTexSubImage1D((int)3552, (int)level, (int)xoffset, (int)x, (int)y, (int)width);
        GL41.glBindTexture((int)3552, (int)prevTex);
    }

    @Override
    public int createBuffer() {
        int[] buffers = new int[1];
        GL41.glGenBuffers((int[])buffers);
        return buffers[0];
    }

    @Override
    public void bufferData(int buffer, int target, Buffer data, int usage) {
        int prevBuffer = GL41.glGetInteger((int)target);
        GL41.glBindBuffer((int)target, (int)buffer);
        if (data instanceof ByteBuffer) {
            GL41.glBufferData((int)target, (ByteBuffer)((ByteBuffer)data), (int)usage);
        } else if (data instanceof FloatBuffer) {
            GL41.glBufferData((int)target, (FloatBuffer)((FloatBuffer)data), (int)usage);
        } else if (data instanceof IntBuffer) {
            GL41.glBufferData((int)target, (IntBuffer)((IntBuffer)data), (int)usage);
        } else if (data instanceof ShortBuffer) {
            GL41.glBufferData((int)target, (ShortBuffer)((ShortBuffer)data), (int)usage);
        } else {
            if (data instanceof LongBuffer) {
                throw new UnsupportedOperationException("LongBuffer not supported in OpenGL 4.1");
            }
            if (data instanceof DoubleBuffer) {
                GL41.glBufferData((int)target, (DoubleBuffer)((DoubleBuffer)data), (int)usage);
            }
        }
        GL41.glBindBuffer((int)target, (int)prevBuffer);
    }

    @Override
    public void bufferSubData(int buffer, int offset, Buffer data) {
        int prevBuffer = GL41.glGetInteger((int)34962);
        GL41.glBindBuffer((int)34962, (int)buffer);
        if (data instanceof ByteBuffer) {
            GL41.glBufferSubData((int)34962, (long)offset, (ByteBuffer)((ByteBuffer)data));
        } else if (data instanceof FloatBuffer) {
            GL41.glBufferSubData((int)34962, (long)offset, (FloatBuffer)((FloatBuffer)data));
        } else if (data instanceof IntBuffer) {
            GL41.glBufferSubData((int)34962, (long)offset, (IntBuffer)((IntBuffer)data));
        } else if (data instanceof ShortBuffer) {
            GL41.glBufferSubData((int)34962, (long)offset, (ShortBuffer)((ShortBuffer)data));
        } else {
            if (data instanceof LongBuffer) {
                throw new UnsupportedOperationException("LongBuffer not supported in OpenGL 4.1");
            }
            if (data instanceof DoubleBuffer) {
                GL41.glBufferSubData((int)34962, (long)offset, (DoubleBuffer)((DoubleBuffer)data));
            }
        }
        GL41.glBindBuffer((int)34962, (int)prevBuffer);
    }

    @Override
    public void deleteBuffer(int buffer) {
        GL41.glDeleteBuffers((int)buffer);
    }

    @Override
    public void bindBufferBase(int target, int bindingPoint, int buffer) {
        GL41.glBindBufferBase((int)target, (int)bindingPoint, (int)buffer);
    }

    @Override
    public void bindVertexArray(int vao) {
        GL41.glBindVertexArray((int)vao);
    }

    @Override
    public void bindImageTexture(int unit, int texture, int level, boolean layered, int layer, int access, int format) {
        GL43.glBindImageTexture((int)unit, (int)texture, (int)level, (boolean)layered, (int)layer, (int)access, (int)format);
    }

    @Override
    public void bindTextureUnit(int unit, int texture) {
        throw new UnsupportedOperationException("bindTextureUnit not available in OpenGL 4.1.");
    }

    @Override
    public void bindSampler(int unit, int sampler) {
        GL41.glBindSampler((int)unit, (int)sampler);
    }

    @Override
    public int createTexture2D() {
        int[] textures = new int[1];
        GL41.glGenTextures((int[])textures);
        return textures[0];
    }

    @Override
    public int createTexture1D() {
        int[] textures = new int[1];
        GL41.glGenTextures((int[])textures);
        return textures[0];
    }

    @Override
    public void textureParameteri(int texture, int pname, int value) {
        int prevTex = GL41.glGetInteger((int)32873);
        GL41.glBindTexture((int)3553, (int)texture);
        GL41.glTexParameteri((int)3553, (int)pname, (int)value);
        GL41.glBindTexture((int)3553, (int)prevTex);
    }

    @Override
    public void textureParameterf(int texture, int pname, float value) {
        int prevTex = GL41.glGetInteger((int)32873);
        GL41.glBindTexture((int)3553, (int)texture);
        GL41.glTexParameterf((int)3553, (int)pname, (float)value);
        GL41.glBindTexture((int)3553, (int)prevTex);
    }

    @Override
    public void textureStorage2D(int target, int levels, int internalFormat, int width, int height) {
        int prevTex = GL41.glGetInteger((int)32873);
        GL41.glBindTexture((int)3553, (int)target);
        if (this.gl43) {
            GL43.glTexStorage2D((int)3553, (int)levels, (int)internalFormat, (int)width, (int)height);
        } else {
            for (int level = 0; level < levels; ++level) {
                int levelWidth = Math.max(1, width >> level);
                int levelHeight = Math.max(1, height >> level);
                GL41.glTexImage2D((int)3553, (int)level, (int)internalFormat, (int)levelWidth, (int)levelHeight, (int)0, (int)CompatDirectStateAccessImpl.getFormatFromInternal(internalFormat), (int)CompatDirectStateAccessImpl.getTypeFromInternal(internalFormat), (ByteBuffer)null);
            }
        }
        GL41.glBindTexture((int)3553, (int)prevTex);
    }

    @Override
    public void textureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixels) {
        int prevTex = GL41.glGetInteger((int)32873);
        GL41.glBindTexture((int)3553, (int)texture);
        GL41.glTexSubImage2D((int)3553, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (long)pixels);
        GL41.glBindTexture((int)3553, (int)prevTex);
    }

    @Override
    public void textureStorage1D(int target, int levels, int internalFormat, int width) {
        int prevTex = GL41.glGetInteger((int)32872);
        GL41.glBindTexture((int)3552, (int)target);
        if (this.gl43) {
            GL43.glTexStorage1D((int)3552, (int)levels, (int)internalFormat, (int)width);
        } else {
            for (int level = 0; level < levels; ++level) {
                int levelWidth = Math.max(1, width >> level);
                GL41.glTexImage1D((int)target, (int)level, (int)internalFormat, (int)levelWidth, (int)0, (int)CompatDirectStateAccessImpl.getFormatFromInternal(internalFormat), (int)CompatDirectStateAccessImpl.getTypeFromInternal(internalFormat), (ByteBuffer)null);
            }
        }
        GL41.glBindTexture((int)3552, (int)prevTex);
    }

    @Override
    public void textureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, long pixels) {
        int prevTex = GL41.glGetInteger((int)32872);
        GL41.glBindTexture((int)3552, (int)texture);
        GL41.glTexSubImage1D((int)3552, (int)level, (int)xoffset, (int)width, (int)format, (int)type, (long)pixels);
        GL41.glBindTexture((int)3552, (int)prevTex);
    }

    @Override
    public int checkNamedFramebufferStatus(int framebuffer, int target) {
        int prevFBO = GL41.glGetInteger((int)36006);
        GL41.glBindFramebuffer((int)target, (int)framebuffer);
        int status = GL41.glCheckFramebufferStatus((int)target);
        GL41.glBindFramebuffer((int)target, (int)prevFBO);
        return status;
    }

    @Override
    public void clearNamedFramebufferfv(int framebuffer, int buffer, int drawbuffer, float[] value) {
        this.clearFramebuffer(framebuffer, buffer, drawbuffer, value);
    }

    @Override
    public void clearNamedFramebufferfi(int framebuffer, int buffer, int drawbuffer, float depth, int stencil) {
        int prevFBO = GL41.glGetInteger((int)36006);
        GL41.glBindFramebuffer((int)36160, (int)framebuffer);
        GL41.glClearBufferfi((int)buffer, (int)drawbuffer, (float)depth, (int)stencil);
        GL41.glBindFramebuffer((int)36160, (int)prevFBO);
    }

    @Override
    public int createVertexArray() {
        int[] vaos = new int[1];
        GL41.glGenVertexArrays((int[])vaos);
        return vaos[0];
    }

    @Override
    public void vertexArrayVertexBuffer(int vao, int bindingIndex, int buffer, long offset, int stride) {
        throw new UnsupportedOperationException("vertexArrayVertexBuffer not available in OpenGL 4.1.");
    }

    @Override
    public void vertexArrayAttribFormat(int vao, int attribIndex, int size, int type, boolean normalized, int relativeOffset) {
        throw new UnsupportedOperationException("vertexArrayAttribFormat not available in OpenGL 4.1.");
    }

    @Override
    public void vertexArrayAttribBinding(int vao, int attribIndex, int bindingIndex) {
        throw new UnsupportedOperationException("vertexArrayAttribBinding not available in OpenGL 4.1.");
    }

    @Override
    public void enableVertexArrayAttrib(int vaobj, int index) {
        int prevVAO = GL41.glGetInteger((int)34229);
        GL41.glBindVertexArray((int)vaobj);
        GL41.glEnableVertexAttribArray((int)index);
        GL41.glBindVertexArray((int)prevVAO);
    }

    @Override
    public int createFramebuffer() {
        int[] fbos = new int[1];
        GL41.glGenFramebuffers((int[])fbos);
        return fbos[0];
    }

    @Override
    public void framebufferTexture(int framebuffer, int attachment, int texture, int level) {
        int prevFBO = GL41.glGetInteger((int)36006);
        GL41.glBindFramebuffer((int)36160, (int)framebuffer);
        GL41.glFramebufferTexture((int)36160, (int)attachment, (int)texture, (int)level);
        GL41.glBindFramebuffer((int)36160, (int)prevFBO);
    }

    @Override
    public void deleteTexture(int texture) {
        GL41.glDeleteTextures((int)texture);
    }

    @Override
    public void deleteVertexArray(int vao) {
        GL41.glDeleteVertexArrays((int)vao);
    }

    @Override
    public void deleteFramebuffer(int fbo) {
        GL41.glDeleteFramebuffers((int)fbo);
    }

    private static int getFormatFromInternal(int internalFormat) {
        return switch (internalFormat) {
            case 33321, 33322, 33325, 33326, 33329, 33330, 33331, 33332, 33333, 33334, 36756, 36760 -> 6403;
            case 33323, 33324, 33327, 33328, 33335, 33336, 33337, 33338, 33339, 33340, 36757, 36761 -> 33319;
            case 32849, 32852, 34837, 34843, 35898, 35905, 36209, 36215, 36221, 36227, 36233, 36239, 36758, 36762 -> 6407;
            case 32856, 32859, 34836, 34842, 35907, 36208, 36214, 36220, 36226, 36232, 36238, 36759, 36763 -> 6408;
            case 33189, 33190, 36012 -> 6402;
            case 35056, 36013 -> 34041;
            case 33317, 33318, 34029, 34030, 35912, 35913 -> throw new IllegalArgumentException("Compressed formats require direct DSA");
            default -> throw new IllegalArgumentException("Unsupported internal format: 0x" + Integer.toHexString(internalFormat));
        };
    }

    private static int getTypeFromInternal(int internalFormat) {
        return switch (internalFormat) {
            case 32849, 32856, 33321, 33323, 35905, 35907 -> 5121;
            case 36756, 36757, 36758, 36759 -> 5120;
            case 32852, 32859, 33322, 33324 -> 5123;
            case 36760, 36761, 36762, 36763 -> 5122;
            case 33325, 33327, 34842, 34843 -> 5131;
            case 33326, 33328, 34836, 34837 -> 5126;
            case 35898 -> 35899;
            case 33330, 33336, 36220, 36221 -> 5121;
            case 33329, 33335, 36238, 36239 -> 5120;
            case 33332, 33338, 36214, 36215 -> 5123;
            case 33331, 33337, 36232, 36233 -> 5122;
            case 33334, 33340, 36208, 36209 -> 5125;
            case 33333, 33339, 36226, 36227 -> 5124;
            case 33189 -> 5123;
            case 33190, 35056 -> 5125;
            case 36012, 36013 -> 5126;
            default -> throw new IllegalArgumentException("Unsupported internal format: 0x" + Integer.toHexString(internalFormat));
        };
    }
}

