/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.vulkan.utils;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VKCapabilitiesInstance;
import org.lwjgl.vulkan.VkApplicationInfo;
import org.lwjgl.vulkan.VkExtensionProperties;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkInstanceCreateInfo;
import sun.misc.Unsafe;

public class VkReflectionHelper {
    private static final Unsafe UNSAFE = VkReflectionHelper.runReflective(() -> {
        Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
        theUnsafe.setAccessible(true);
        return (Unsafe)theUnsafe.get(null);
    });
    private static final MethodHandles.Lookup IMPL_LOOKUP = VkReflectionHelper.runReflective(() -> {
        Field implLookup = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
        Object base = UNSAFE.staticFieldBase(implLookup);
        long l = UNSAFE.staticFieldOffset(implLookup);
        return (MethodHandles.Lookup)UNSAFE.getObject(base, l);
    });
    private static final VarHandle capabilitiesField = VkReflectionHelper.runReflective(() -> IMPL_LOOKUP.findVarHandle(Class.forName("org.lwjgl.vulkan.DispatchableHandleInstance"), "capabilities", VKCapabilitiesInstance.class));
    private static final VarHandle addressField = VkReflectionHelper.runReflective(() -> IMPL_LOOKUP.findVarHandle(Class.forName("org.lwjgl.system.Pointer$Default"), "address", Long.TYPE));
    private static final Class<?> GlobalCommands = VkReflectionHelper.runReflective(() -> Class.forName("org.lwjgl.vulkan.VK$GlobalCommands"));
    private static final MethodHandle newVKCapabilitiesInstance = VkReflectionHelper.runReflective(() -> IMPL_LOOKUP.findConstructor(VKCapabilitiesInstance.class, MethodType.methodType(Void.TYPE, FunctionProvider.class, Integer.TYPE, Set.class, Set.class)));
    private static final MethodHandle getEnabledExtensionSet = VkReflectionHelper.runReflective(() -> IMPL_LOOKUP.findStatic(VK.class, "getEnabledExtensionSet", MethodType.methodType(Set.class, Integer.TYPE, PointerBuffer.class)));
    private static final MethodHandle getGlobalCommands = VkReflectionHelper.runReflective(() -> IMPL_LOOKUP.findStatic(VK.class, "getGlobalCommands", MethodType.methodType(GlobalCommands)));
    private static final VarHandle vkGetInstanceProcAddr = VkReflectionHelper.runReflective(() -> IMPL_LOOKUP.findVarHandle(GlobalCommands, "vkGetInstanceProcAddr", Long.TYPE));

    public static VkInstance createVkInstanceSafely(long handle, VkInstanceCreateInfo ci) {
        try {
            VKCapabilitiesInstance capabilities = VkReflectionHelper.getInstanceCapabilities(handle, ci);
            VkInstance instance = (VkInstance)UNSAFE.allocateInstance(VkInstance.class);
            capabilitiesField.set(instance, capabilities);
            addressField.set(instance, handle);
            return instance;
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static VKCapabilitiesInstance getInstanceCapabilities(long handle, VkInstanceCreateInfo ci) {
        VkApplicationInfo appInfo = ci.pApplicationInfo();
        int apiVersion = appInfo != null && appInfo.apiVersion() != 0 ? appInfo.apiVersion() : VK10.VK_API_VERSION_1_0;
        try {
            return newVKCapabilitiesInstance.invoke(functionName -> {
                long address = JNI.callPPP((long)handle, (long)MemoryUtil.memAddress((ByteBuffer)functionName), (long)VkReflectionHelper.getVkGetInstanceProcAddr());
                if (address != 0L || Checks.DEBUG_FUNCTIONS) {
                    // empty if block
                }
                return address;
            }, apiVersion, getEnabledExtensionSet.invoke(apiVersion, ci.ppEnabledExtensionNames()), VkReflectionHelper.getAvailableDeviceExtensions(handle));
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Set<String> getAvailableDeviceExtensions(long instance) {
        HashSet<String> extensions = new HashSet<String>();
        try (MemoryStack stack = MemoryStack.stackPush();){
            int err;
            IntBuffer ip = stack.callocInt(1);
            long GetInstanceProcAddr = VkReflectionHelper.getVkGetInstanceProcAddr();
            long EnumeratePhysicalDevices = JNI.callPPP((long)instance, (long)MemoryUtil.memAddress((ByteBuffer)stack.ASCII((CharSequence)"vkEnumeratePhysicalDevices")), (long)GetInstanceProcAddr);
            long EnumerateDeviceExtensionProperties = JNI.callPPP((long)instance, (long)MemoryUtil.memAddress((ByteBuffer)stack.ASCII((CharSequence)"vkEnumerateDeviceExtensionProperties")), (long)GetInstanceProcAddr);
            if (EnumeratePhysicalDevices != 0L && EnumerateDeviceExtensionProperties != 0L && (err = JNI.callPPPI((long)instance, (long)MemoryUtil.memAddress((IntBuffer)ip), (long)0L, (long)EnumeratePhysicalDevices)) == 0 && ip.get(0) != 0) {
                PointerBuffer physicalDevices = stack.mallocPointer(ip.get(0));
                err = JNI.callPPPI((long)instance, (long)MemoryUtil.memAddress((IntBuffer)ip), (long)MemoryUtil.memAddress((CustomBuffer)physicalDevices), (long)EnumeratePhysicalDevices);
                if (err == 0) {
                    for (int i = 0; i < physicalDevices.remaining(); ++i) {
                        err = JNI.callPPPPI((long)physicalDevices.get(i), (long)0L, (long)MemoryUtil.memAddress((IntBuffer)ip), (long)0L, (long)EnumerateDeviceExtensionProperties);
                        if (err != 0 || ip.get(0) == 0) continue;
                        try (VkExtensionProperties.Buffer deviceExtensions = VkExtensionProperties.malloc((int)ip.get(0));){
                            err = JNI.callPPPPI((long)physicalDevices.get(i), (long)0L, (long)MemoryUtil.memAddress((IntBuffer)ip), (long)deviceExtensions.address(), (long)EnumerateDeviceExtensionProperties);
                            if (err != 0) continue;
                            for (int j = 0; j < deviceExtensions.remaining(); ++j) {
                                extensions.add(((VkExtensionProperties)deviceExtensions.get(j)).extensionNameString());
                            }
                            continue;
                        }
                    }
                }
            }
        }
        return extensions;
    }

    public static long getVkGetInstanceProcAddr() {
        try {
            return vkGetInstanceProcAddr.get(getGlobalCommands.invoke());
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private static <T> T runReflective(Callable<T> getter) {
        try {
            return getter.call();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }
}

