/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.style;

import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaUnit;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaValue;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.numeric.FloatOptional;

public class StyleSizeLength {
    public static final StyleSizeLength AUTO = new StyleSizeLength(FloatOptional.of(), YogaUnit.AUTO);
    public static final StyleSizeLength MAX_CONTENT = new StyleSizeLength(FloatOptional.of(), YogaUnit.MAX_CONTENT);
    public static final StyleSizeLength FIT_CONTENT = new StyleSizeLength(FloatOptional.of(), YogaUnit.FIT_CONTENT);
    public static final StyleSizeLength STRETCH = new StyleSizeLength(FloatOptional.of(), YogaUnit.STRETCH);
    public static final StyleSizeLength UNDEFINED = new StyleSizeLength(FloatOptional.of(), YogaUnit.UNDEFINED);
    private FloatOptional value;
    private YogaUnit unit;

    private StyleSizeLength(FloatOptional value, YogaUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    public static StyleSizeLength points(float value) {
        return Float.isNaN(value) || Float.isInfinite(value) ? StyleSizeLength.undefined() : new StyleSizeLength(FloatOptional.of(value), YogaUnit.POINT);
    }

    public static StyleSizeLength percent(float value) {
        return Float.isNaN(value) || Float.isInfinite(value) ? StyleSizeLength.undefined() : new StyleSizeLength(FloatOptional.of(value), YogaUnit.PERCENT);
    }

    public static StyleSizeLength ofAuto() {
        return AUTO;
    }

    public static StyleSizeLength ofMaxContent() {
        return MAX_CONTENT;
    }

    public static StyleSizeLength ofFitContent() {
        return FIT_CONTENT;
    }

    public static StyleSizeLength ofStretch() {
        return STRETCH;
    }

    public static StyleSizeLength undefined() {
        return UNDEFINED;
    }

    public boolean isAuto() {
        return this.unit == YogaUnit.AUTO;
    }

    public boolean isMaxContent() {
        return this.unit == YogaUnit.MAX_CONTENT;
    }

    public boolean isFitContent() {
        return this.unit == YogaUnit.FIT_CONTENT;
    }

    public boolean isStretch() {
        return this.unit == YogaUnit.STRETCH;
    }

    public boolean isUndefined() {
        return this.unit == YogaUnit.UNDEFINED;
    }

    public boolean isDefined() {
        return !this.isUndefined();
    }

    public boolean isPoints() {
        return this.unit == YogaUnit.POINT;
    }

    public boolean isPercent() {
        return this.unit == YogaUnit.PERCENT;
    }

    public FloatOptional value() {
        return this.value;
    }

    public FloatOptional resolve(float referenceLength) {
        return switch (this.unit) {
            case YogaUnit.POINT -> this.value;
            case YogaUnit.PERCENT -> FloatOptional.of(this.value.unwrap() * referenceLength * 0.01f);
            default -> FloatOptional.of();
        };
    }

    public YogaValue asYogaValue() {
        return new YogaValue(this.value.unwrap(), this.unit);
    }

    public static StyleSizeLength fromYogaValue(YogaValue value) {
        return new StyleSizeLength(FloatOptional.of(value.value), value.unit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StyleSizeLength other = (StyleSizeLength)obj;
        return this.value.equals(other.value) && this.unit == other.unit;
    }

    public boolean inexactEquals(StyleSizeLength other) {
        return this.unit == other.unit && this.value.inexactEquals(other.value);
    }

    public String toString() {
        return switch (this.unit) {
            default -> throw new MatchException(null, null);
            case YogaUnit.UNDEFINED, YogaUnit.AUTO, YogaUnit.MAX_CONTENT, YogaUnit.FIT_CONTENT, YogaUnit.STRETCH -> this.unit.toString();
            case YogaUnit.POINT -> this.value.toString();
            case YogaUnit.PERCENT -> String.valueOf(this.value) + "%";
        };
    }
}

