/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.gui.entries;

import io.homo.superresolution.core.utils.ColorUtil;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClothChartEntry
extends TooltipListEntry<Object> {
    private String name;
    private final Deque<Float> data;
    private float min = Float.MAX_VALUE;
    private float max = Float.MIN_VALUE;
    private float sum = 0.0f;
    private float displayMax = 100.0f;
    private float displayMin = 0.0f;
    private Consumer<ClothChartEntry> renderCallback = null;

    public ClothChartEntry setName(String name) {
        this.name = name;
        return this;
    }

    public ClothChartEntry(String name, Component fieldName, @Nullable Supplier<Optional<Component[]>> tooltipSupplier) {
        super(fieldName, tooltipSupplier);
        this.name = name;
        this.data = new ArrayDeque<Float>();
    }

    public void setDisplayRange(float min, float max) {
        this.displayMin = min;
        this.displayMax = max;
    }

    public void setRenderCallback(Consumer<ClothChartEntry> callback) {
        this.renderCallback = callback;
    }

    public void push(float value, int maxDataPoints) {
        this.data.addLast(Float.valueOf(value));
        this.sum += value;
        if (value > this.max) {
            this.max = value;
        }
        if (value < this.min) {
            this.min = value;
        }
        if (this.data.size() > maxDataPoints) {
            float removed = this.data.removeFirst().floatValue();
            this.sum -= removed;
            if (removed == this.min || removed == this.max) {
                this.recalculateMinMax();
            }
        }
    }

    private void recalculateMinMax() {
        if (this.data.isEmpty()) {
            this.min = Float.MAX_VALUE;
            this.max = Float.MIN_VALUE;
            return;
        }
        this.min = Float.MAX_VALUE;
        this.max = Float.MIN_VALUE;
        for (float v : this.data) {
            if (v > this.max) {
                this.max = v;
            }
            if (!(v < this.min)) continue;
            this.min = v;
        }
    }

    public int getItemHeight() {
        return 100;
    }

    public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        Font font = Minecraft.getInstance().font;
        graphics.drawCenteredString(font, this.name, x + entryWidth / 2, y + 2, ColorUtil.color(255, 255, 255, 255));
        if (!this.data.isEmpty()) {
            int chartWidth;
            float avg = this.sum / (float)this.data.size();
            String stats = String.format("AVG: %.2f MAX: %.2f MIN: %.2f", Float.valueOf(avg), Float.valueOf(this.max), Float.valueOf(this.min));
            graphics.drawCenteredString(font, stats, x + entryWidth / 2, y + 12, ColorUtil.color(255, 255, 255, 255));
            int chartHeight = entryHeight - 24;
            int chartY = y + 24;
            int chartX = x + 4;
            int maxDataPoints = chartWidth = entryWidth - 8;
            while (this.data.size() > maxDataPoints) {
                float removed = this.data.removeFirst().floatValue();
                this.sum -= removed;
                if (removed != this.min && removed != this.max) continue;
                this.recalculateMinMax();
            }
            float range = this.displayMax - this.displayMin == 0.0f ? 1.0f : this.displayMax - this.displayMin;
            float scaleY = (float)chartHeight / range;
            int i = 0;
            for (float v : this.data) {
                int barX = chartX + i;
                int barHeight = (int)((this.clamp(v) - this.displayMin) * scaleY);
                int barY = chartY + chartHeight - barHeight;
                graphics.fill(barX, barY, barX + 1, chartY + chartHeight, i % 2 == 0 ? ColorUtil.color(255, 255, 0, 0) : ColorUtil.color(100, 255, 0, 0));
                ++i;
            }
            int avgY = chartY + chartHeight - (int)((this.clamp(avg) - this.displayMin) * scaleY);
            graphics.hLine(chartX, chartX + chartWidth, avgY, -16776961);
        }
        if (this.renderCallback != null) {
            this.renderCallback.accept(this);
        }
    }

    private float clamp(float v) {
        if (v < this.displayMin) {
            return this.displayMin;
        }
        if (v > this.displayMax) {
            return this.displayMax;
        }
        return v;
    }

    public Optional<Object> getDefaultValue() {
        return Optional.empty();
    }

    public Object getValue() {
        return null;
    }

    @NotNull
    public List<? extends GuiEventListener> children() {
        return Collections.emptyList();
    }

    public List<? extends NarratableEntry> narratables() {
        return Collections.emptyList();
    }
}

