/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.gui.options;

import io.homo.superresolution.common.gui.impl.Text;
import io.homo.superresolution.common.gui.options.AbstractOptionEntry;
import io.homo.superresolution.common.gui.options.OptionContainerWidget;
import io.homo.superresolution.core.gui.MaterialScheme;
import io.homo.superresolution.core.gui.core.UIInputState;
import io.homo.superresolution.core.gui.core.backends.interfaces.IUIDrawContext;
import io.homo.superresolution.core.gui.widgets.label.MaterialLabel;
import io.homo.superresolution.core.gui.widgets.sliders.MaterialSlider;
import io.homo.superresolution.core.gui.widgets.sliders.MaterialSliderSize;
import io.homo.superresolution.core.gui.widgets.sliders.MaterialSliderStyle;
import java.util.function.Function;

public class NumberSliderOptionEntry
extends AbstractOptionEntry<Number, NumberSliderOptionEntry> {
    protected MaterialSlider slider;
    protected MaterialLabel label;
    protected Number max;
    protected Number min;
    protected Number step;
    protected Function<Number, String> valueFormater;

    public NumberSliderOptionEntry(Text name, Number value, Number max, Number min) {
        super(name, value);
        this.max = max;
        this.min = min;
        this.init();
    }

    @Override
    protected void init() {
        this.container = new OptionContainerWidget(this);
        this.initLayout();
        this.initWidget();
    }

    @Override
    protected void initLayout() {
    }

    @Override
    protected NumberSliderOptionEntry setScheme(MaterialScheme scheme) {
        this.slider.scheme(scheme);
        this.label.scheme(scheme);
        return (NumberSliderOptionEntry)super.setScheme(scheme);
    }

    @Override
    protected void initWidget() {
        this.slider = (MaterialSlider)MaterialSlider.create().scheme(this.scheme);
        this.label = MaterialLabel.create().text(() -> this.name.getString());
        this.container.addChild(this.slider);
        this.container.addChild(this.label);
        this.container.scheme(this.scheme);
        ((MaterialSliderStyle)this.slider.style()).valueIndicator(true);
        if (this.step != null && this.step.doubleValue() != 0.0) {
            ((MaterialSliderStyle)this.slider.style()).steps(true);
            this.slider.setStep(this.step);
        }
        ((MaterialSliderStyle)this.slider.style()).size(MaterialSliderSize.ExtraSmall);
        this.slider.setValueIndicatorTextFormater(this.valueFormater);
        this.slider.setMin(this.min);
        this.slider.setMax(this.max);
        this.slider.setValue((Number)this.value);
    }

    @Override
    public void render(IUIDrawContext drawContext, UIInputState inputState) {
        this.container.render(drawContext, inputState);
    }
}

