/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.perf;

import io.homo.superresolution.common.config.SuperResolutionConfig;
import org.lwjgl.opengl.GL41;

public class PerformanceRecoder {
    private static int[] timeQueryIds = new int[3];
    private static float frameTime;
    private static boolean queriesInitialized;
    private static long worldTimeNs;
    private static long upscaleTimeNs;
    private static long frameTimeNs;
    private static long cpuWorldTimeNs;
    private static long cpuUpscaleTimeNs;
    private static long cpuFrameTimeNs;
    private static long cpuWorldStartTimeNs;
    private static long cpuUpscaleStartTimeNs;
    private static long cpuFrameStartTimeNs;

    public static void initialize() {
        if (!queriesInitialized) {
            GL41.glGenQueries((int[])timeQueryIds);
            queriesInitialized = true;
        }
    }

    public static void beginFrame() {
        cpuFrameStartTimeNs = System.nanoTime();
    }

    public static void endFrame() {
        frameTimeNs = cpuFrameTimeNs = System.nanoTime() - cpuFrameStartTimeNs;
        frameTime = (float)cpuFrameTimeNs / 1000000.0f;
    }

    public static void beginUpscale() {
        cpuUpscaleStartTimeNs = System.nanoTime();
        if (SuperResolutionConfig.isEnableDetailedProfiling()) {
            GL41.glBeginQuery((int)35007, (int)timeQueryIds[1]);
        }
    }

    public static void endUpscale() {
        cpuUpscaleTimeNs = System.nanoTime() - cpuUpscaleStartTimeNs;
        if (SuperResolutionConfig.isEnableDetailedProfiling()) {
            GL41.glEndQuery((int)35007);
            long[] upscaleTime = new long[]{0L};
            GL41.glGetQueryObjectui64v((int)timeQueryIds[1], (int)34918, (long[])upscaleTime);
            upscaleTimeNs = upscaleTime[0];
        }
    }

    public static void beginWorld() {
        cpuWorldStartTimeNs = System.nanoTime();
        if (SuperResolutionConfig.isEnableDetailedProfiling()) {
            GL41.glBeginQuery((int)35007, (int)timeQueryIds[0]);
        }
    }

    public static void endWorld() {
        cpuWorldTimeNs = System.nanoTime() - cpuWorldStartTimeNs;
        if (SuperResolutionConfig.isEnableDetailedProfiling()) {
            GL41.glEndQuery((int)35007);
            long[] worldTime = new long[]{0L};
            GL41.glGetQueryObjectui64v((int)timeQueryIds[0], (int)34918, (long[])worldTime);
            worldTimeNs = worldTime[0];
        }
    }

    public static long getWorldTimeNs() {
        return worldTimeNs;
    }

    public static float getWorldTimeMs() {
        return (float)worldTimeNs / 1000000.0f;
    }

    public static long getUpscaleTimeNs() {
        return upscaleTimeNs;
    }

    public static float getUpscaleTimeMs() {
        return (float)upscaleTimeNs / 1000000.0f;
    }

    public static long getFrameTimeNs() {
        return frameTimeNs;
    }

    public static float getFrameTimeMs() {
        return (float)frameTimeNs / 1000000.0f;
    }

    public static long getCpuWorldTimeNs() {
        return cpuWorldTimeNs;
    }

    public static float getCpuWorldTimeMs() {
        return (float)cpuWorldTimeNs / 1000000.0f;
    }

    public static long getCpuUpscaleTimeNs() {
        return cpuUpscaleTimeNs;
    }

    public static float getCpuUpscaleTimeMs() {
        return (float)cpuUpscaleTimeNs / 1000000.0f;
    }

    public static long getCpuFrameTimeNs() {
        return cpuFrameTimeNs;
    }

    public static float getCpuFrameTimeMs() {
        return (float)cpuFrameTimeNs / 1000000.0f;
    }

    static {
        queriesInitialized = false;
        worldTimeNs = 0L;
        upscaleTimeNs = 0L;
        frameTimeNs = 0L;
        cpuWorldTimeNs = 0L;
        cpuUpscaleTimeNs = 0L;
        cpuFrameTimeNs = 0L;
        cpuWorldStartTimeNs = 0L;
        cpuUpscaleStartTimeNs = 0L;
        cpuFrameStartTimeNs = 0L;
    }
}

