/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl.buffer;

import io.homo.superresolution.core.graphics.impl.buffer.IBufferData;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryUtil;

public class StructuredUniformBuffer
implements IBufferData {
    protected final int size;
    protected final ByteBuffer container;
    private final Map<String, Entry> entries;

    protected StructuredUniformBuffer(ByteBuffer buffer, Map<String, Entry> entries, int size) {
        this.container = buffer;
        this.entries = entries;
        this.size = size;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void put(byte[] src, long offset) {
        throw new RuntimeException();
    }

    @Override
    public void updatePartial(Buffer data, long offset, long length) {
        Objects.requireNonNull(data, "Data buffer cannot be null");
        if (offset < 0L || length < 0L || offset + length > (long)this.size) {
            throw new IndexOutOfBoundsException("Invalid offset or length");
        }
        if ((long)data.remaining() < length) {
            throw new IllegalArgumentException("Not enough data in input buffer");
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((Buffer)data), (long)(MemoryUtil.memAddress((ByteBuffer)this.container) + offset), (long)length);
    }

    @Override
    public void update(Buffer data) {
        Objects.requireNonNull(data, "Data buffer cannot be null");
        if (data.limit() != this.size) {
            throw new IllegalArgumentException("Data size must match buffer size");
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((Buffer)data), (long)MemoryUtil.memAddress((ByteBuffer)this.container), (long)this.size);
    }

    @Override
    public ByteBuffer container() {
        return this.container;
    }

    public StructuredUniformBuffer setFloat(String name, float value) {
        Entry entry = this.entries.get(name);
        if (!(entry instanceof FloatEntry)) {
            throw new IllegalArgumentException("Entry '" + name + "' is not a float");
        }
        ((FloatEntry)entry).setValue(value);
        return this;
    }

    public StructuredUniformBuffer setInt(String name, int value) {
        Entry entry = this.entries.get(name);
        if (!(entry instanceof IntEntry)) {
            throw new IllegalArgumentException("Entry '" + name + "' is not an int");
        }
        ((IntEntry)entry).setValue(value);
        return this;
    }

    public StructuredUniformBuffer setBool(String name, boolean value) {
        Entry entry = this.entries.get(name);
        if (!(entry instanceof BoolEntry)) {
            throw new IllegalArgumentException("Entry '" + name + "' is not a boolean");
        }
        ((BoolEntry)entry).setValue(value);
        return this;
    }

    public StructuredUniformBuffer setVec2(String name, Vector2f value) {
        return this.setVec2(name, value.x, value.y);
    }

    public StructuredUniformBuffer setVec2(String name, float x, float y) {
        Entry entry = this.entries.get(name);
        if (!(entry instanceof Vec2Entry)) {
            throw new IllegalArgumentException("Entry '" + name + "' is not a vec2");
        }
        ((Vec2Entry)entry).setValue(x, y);
        return this;
    }

    public StructuredUniformBuffer setVec3(String name, Vector3f value) {
        return this.setVec3(name, value.x, value.y, value.z);
    }

    public StructuredUniformBuffer setVec3(String name, float x, float y, float z) {
        Entry entry = this.entries.get(name);
        if (!(entry instanceof Vec3Entry)) {
            throw new IllegalArgumentException("Entry '" + name + "' is not a vec3");
        }
        ((Vec3Entry)entry).setValue(x, y, z);
        return this;
    }

    public StructuredUniformBuffer setVec4(String name, Vector4f value) {
        return this.setVec4(name, value.x, value.y, value.z, value.w);
    }

    public StructuredUniformBuffer setVec4(String name, float x, float y, float z, float w) {
        Entry entry = this.entries.get(name);
        if (!(entry instanceof Vec4Entry)) {
            throw new IllegalArgumentException("Entry '" + name + "' is not a vec4");
        }
        ((Vec4Entry)entry).setValue(x, y, z, w);
        return this;
    }

    public StructuredUniformBuffer setMat4(String name, Matrix4f value) {
        Entry entry = this.entries.get(name);
        if (!(entry instanceof Mat4Entry)) {
            throw new IllegalArgumentException("Entry '" + name + "' is not a mat4");
        }
        ((Mat4Entry)entry).setValue(value);
        return this;
    }

    public StructuredUniformBuffer setUint(String name, int value) {
        Entry entry = this.entries.get(name);
        if (!(entry instanceof UintEntry)) {
            throw new IllegalArgumentException("Entry '" + name + "' is not a uint");
        }
        ((UintEntry)entry).setValue(value);
        return this;
    }

    @Override
    public void free() {
        this.entries.clear();
        MemoryUtil.memFree((Buffer)this.container);
    }

    public void fillBuffer() {
        for (Entry entry : this.entries.values()) {
            entry.update(this.container);
        }
    }

    static abstract class Entry {
        protected final int offset;

        protected Entry(int offset) {
            this.offset = offset;
        }

        public abstract void update(ByteBuffer var1);
    }

    static class FloatEntry
    extends Entry {
        private float value;

        public FloatEntry(int offset) {
            super(offset);
        }

        public void setValue(float value) {
            this.value = value;
        }

        @Override
        public void update(ByteBuffer buffer) {
            buffer.putFloat(this.offset, this.value);
        }
    }

    static class IntEntry
    extends Entry {
        private int value;

        public IntEntry(int offset) {
            super(offset);
        }

        public void setValue(int value) {
            this.value = value;
        }

        @Override
        public void update(ByteBuffer buffer) {
            buffer.putInt(this.offset, this.value);
        }
    }

    static class BoolEntry
    extends Entry {
        private boolean value;

        public BoolEntry(int offset) {
            super(offset);
        }

        public void setValue(boolean value) {
            this.value = value;
        }

        @Override
        public void update(ByteBuffer buffer) {
            buffer.putInt(this.offset, this.value ? 1 : 0);
        }
    }

    static class Vec2Entry
    extends Entry {
        private float x;
        private float y;

        public Vec2Entry(int offset) {
            super(offset);
        }

        public void setValue(float x, float y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public void update(ByteBuffer buffer) {
            buffer.putFloat(this.offset, this.x);
            buffer.putFloat(this.offset + 4, this.y);
        }
    }

    static class Vec3Entry
    extends Entry {
        private float x;
        private float y;
        private float z;

        public Vec3Entry(int offset) {
            super(offset);
        }

        public void setValue(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public void update(ByteBuffer buffer) {
            buffer.putFloat(this.offset, this.x);
            buffer.putFloat(this.offset + 4, this.y);
            buffer.putFloat(this.offset + 8, this.z);
        }
    }

    static class Vec4Entry
    extends Entry {
        private float x;
        private float y;
        private float z;
        private float w;

        public Vec4Entry(int offset) {
            super(offset);
        }

        public void setValue(float x, float y, float z, float w) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = w;
        }

        @Override
        public void update(ByteBuffer buffer) {
            buffer.putFloat(this.offset, this.x);
            buffer.putFloat(this.offset + 4, this.y);
            buffer.putFloat(this.offset + 8, this.z);
            buffer.putFloat(this.offset + 12, this.w);
        }
    }

    static class Mat4Entry
    extends Entry {
        private final Matrix4f value = new Matrix4f();

        public Mat4Entry(int offset) {
            super(offset);
        }

        public void setValue(Matrix4f matrix) {
            this.value.set((Matrix4fc)matrix);
        }

        @Override
        public void update(ByteBuffer buffer) {
            this.value.get(this.offset, buffer);
        }
    }

    static class UintEntry
    extends Entry {
        private int value;

        public UintEntry(int offset) {
            super(offset);
        }

        public void setValue(int value) {
            this.value = value;
        }

        @Override
        public void update(ByteBuffer buffer) {
            buffer.putInt(this.offset, this.value);
        }
    }
}

