/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.core.backends.nanovg;

import io.homo.superresolution.core.gui.core.backends.interfaces.IFont;
import io.homo.superresolution.core.gui.core.backends.interfaces.ITextRenderer;
import io.homo.superresolution.core.gui.core.backends.interfaces.TextAlign;
import io.homo.superresolution.core.gui.core.backends.interfaces.TextAlignType;
import io.homo.superresolution.core.gui.core.backends.nanovg.NanoVGContext;
import io.homo.superresolution.core.gui.core.backends.nanovg.NanoVGFont;
import io.homo.superresolution.core.gui.core.backends.nanovg.NanoVGRendererBase;
import io.homo.superresolution.core.utils.Color;
import java.util.ArrayList;
import java.util.List;
import org.joml.Vector2f;
import org.lwjgl.nanovg.NVGColor;
import org.lwjgl.nanovg.NanoVG;

public class NanoVGTextRenderer
extends NanoVGRendererBase
implements ITextRenderer {
    public static NanoVGTextRenderer INSTANCE;

    public NanoVGTextRenderer(NanoVGContext context) {
        INSTANCE = this;
    }

    private List<String> splitText(String text, float maxWidth, float fontSize) {
        ArrayList<String> lines = new ArrayList<String>();
        if (text == null || text.isEmpty() || maxWidth <= 0.0f) {
            return lines;
        }
        int lineStart = 0;
        int textLength = text.length();
        while (lineStart < textLength) {
            int lineEnd = this.findLineEnd(text, lineStart, maxWidth, fontSize);
            lines.add(text.substring(lineStart, lineEnd));
            lineStart = lineEnd;
        }
        return lines;
    }

    private int findLineEnd(String text, int start, float maxWidth, float fontSize) {
        int end;
        float width = 0.0f;
        char[] characters = text.toCharArray();
        for (end = start; end < characters.length && !((width += this.measureTextWidth(String.valueOf(characters[end]), fontSize)) > maxWidth); ++end) {
        }
        return end;
    }

    @Override
    public float measureTextWidth(String text, float fontSize) {
        if (text == null || text.isEmpty()) {
            return 0.0f;
        }
        float[] bounds = new float[4];
        NanoVG.nvgFontSize((long)this.contextPtr, (float)fontSize);
        NanoVG.nvgTextBounds((long)this.contextPtr, (float)0.0f, (float)0.0f, (CharSequence)text, (float[])bounds);
        return bounds[2] - bounds[0];
    }

    @Override
    public float measureTextHeight(String text, float fontSize) {
        float[] bounds = new float[4];
        NanoVG.nvgFontSize((long)this.contextPtr, (float)fontSize);
        NanoVG.nvgTextBounds((long)this.contextPtr, (float)0.0f, (float)0.0f, (CharSequence)text, (float[])bounds);
        return bounds[3] - bounds[1] - 2.0f;
    }

    @Override
    public Vector2f measureText(String text, float fontSize) {
        float[] bounds = new float[4];
        NanoVG.nvgFontSize((long)this.contextPtr, (float)fontSize);
        NanoVG.nvgTextBounds((long)this.contextPtr, (float)0.0f, (float)0.0f, (CharSequence)text, (float[])bounds);
        return new Vector2f(bounds[2] - bounds[0], bounds[3] - bounds[1] - 2.5f);
    }

    @Override
    public void drawAlignedText(IFont font, float fontSize, String text, float startX, float startY, float maxWidth, float lineHeight, Color color, TextAlign align, boolean wrap) {
        color = color.copy().alpha((int)(this.nvg.globalAlpha() * (float)color.alpha()));
        String fontName = ((NanoVGFont)font).name;
        NanoVG.nvgSave((long)this.contextPtr);
        TextMetrics metrics = this.calculateTextMetrics(fontName, fontSize, text, maxWidth, lineHeight, wrap);
        NanoVG.nvgTextAlign((long)this.contextPtr, (int)(this.toNvgAlign(align.horizontal()) | this.toNvgAlign(align.vertical())));
        NanoVG.nvgFontSize((long)this.contextPtr, (float)fontSize);
        NanoVG.nvgFontFace((long)this.contextPtr, (CharSequence)fontName);
        NanoVG.nvgFillColor((long)this.contextPtr, (NVGColor)color.nvg());
        float yPos = startY + 1.5f;
        for (String line : metrics.lines) {
            NanoVG.nvgText((long)this.contextPtr, (float)startX, (float)yPos, (CharSequence)line);
            yPos += lineHeight;
        }
        NanoVG.nvgRestore((long)this.contextPtr);
    }

    private int toNvgAlign(TextAlignType alignType) {
        return switch (alignType) {
            default -> throw new MatchException(null, null);
            case TextAlignType.ALIGN_LEFT -> 1;
            case TextAlignType.ALIGN_CENTER -> 2;
            case TextAlignType.ALIGN_RIGHT -> 4;
            case TextAlignType.ALIGN_TOP -> 8;
            case TextAlignType.ALIGN_MIDDLE -> 16;
            case TextAlignType.ALIGN_BOTTOM -> 32;
        };
    }

    private float calculateHorizontalPosition(String line, float maxWidth, TextAlign align, float fontSize) {
        float lineWidth = this.measureTextWidth(line, fontSize);
        return switch (align.horizontal()) {
            case TextAlignType.ALIGN_CENTER -> (maxWidth - lineWidth) / 2.0f;
            case TextAlignType.ALIGN_RIGHT -> maxWidth - lineWidth;
            default -> 0.0f;
        };
    }

    public TextMetrics calculateTextMetrics(NanoVGFont fontName, float fontSize, String text, float maxWidth, float lineHeight, boolean wrap) {
        return this.calculateTextMetrics(fontName.name, fontSize, text, maxWidth, lineHeight, wrap);
    }

    public TextMetrics calculateTextMetrics(String fontName, float fontSize, String text, float maxWidth, float lineHeight, boolean wrap) {
        NanoVG.nvgSave((long)this.contextPtr);
        NanoVG.nvgFontSize((long)this.contextPtr, (float)fontSize);
        NanoVG.nvgFontFace((long)this.contextPtr, (CharSequence)fontName);
        List<String> lines = wrap ? this.splitText(text, maxWidth, fontSize) : List.of(text.split("\n"));
        float maxLineWidth = 0.0f;
        for (String line : lines) {
            float width = this.measureTextWidth(line, fontSize);
            if (!(width > maxLineWidth)) continue;
            maxLineWidth = width;
        }
        NanoVG.nvgRestore((long)this.contextPtr);
        return new TextMetrics(lines, lineHeight, maxLineWidth);
    }

    private float calculateVerticalOffset(int align, TextMetrics metrics) {
        return switch (align) {
            case 32 -> -metrics.totalHeight;
            case 8 -> 0.0f;
            case 16 -> -metrics.totalHeight * 0.5f;
            default -> 0.0f;
        };
    }

    public static class TextMetrics {
        public final List<String> lines;
        public final float totalHeight;
        public final float maxLineWidth;

        public TextMetrics(List<String> lines, float lineHeight, float maxLineWidth) {
            this.lines = lines;
            this.totalHeight = Math.max((float)lines.size() * lineHeight - 4.0f, 0.0f);
            this.maxLineWidth = maxLineWidth;
        }
    }
}

