/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.utils;

import io.homo.superresolution.core.utils.Color;
import java.util.Arrays;

public class ColorUtil {
    public static int alpha(int color) {
        return color >>> 24;
    }

    public static int red(int color) {
        return color >> 16 & 0xFF;
    }

    public static int green(int color) {
        return color >> 8 & 0xFF;
    }

    public static int blue(int color) {
        return color & 0xFF;
    }

    public static int color(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int color(int red, int green, int blue) {
        return ColorUtil.color(255, red, green, blue);
    }

    public static String RGB_to_RGBA(String code) {
        String codeData = code.replace("#", "");
        if (codeData.length() == 6) {
            return "#FF" + codeData.toUpperCase();
        }
        if (codeData.length() == 8) {
            return code.toUpperCase();
        }
        throw new IllegalArgumentException("Invalid RGB color code: " + code);
    }

    public static int[] toArray(String code, String toFormat) {
        code = ColorUtil.RGB_to_RGBA(code).replace("#", "");
        int a = Integer.parseInt(code.substring(0, 2), 16);
        int r = Integer.parseInt(code.substring(2, 4), 16);
        int g = Integer.parseInt(code.substring(4, 6), 16);
        int b = Integer.parseInt(code.substring(6, 8), 16);
        toFormat = toFormat.toLowerCase();
        if (!Arrays.asList("rgba", "argb", "rgb").contains(toFormat)) {
            throw new IllegalArgumentException(toFormat + " is not a valid format (rgba, argb, rgb)");
        }
        if (toFormat.equals("rgba")) {
            return new int[]{r, g, b, a};
        }
        if (toFormat.equals("argb")) {
            return new int[]{a, r, g, b};
        }
        if (toFormat.equals("rgb")) {
            return new int[]{r, g, b};
        }
        throw new IllegalArgumentException("Invalid format: " + toFormat);
    }

    public static int[] toArray(Object code) {
        if (code instanceof int[]) {
            return (int[])code;
        }
        if (code instanceof String) {
            return ColorUtil.toArray((String)code, "rgba");
        }
        throw new IllegalArgumentException("Unsupported code type: " + code.getClass().getName());
    }

    public static String toCode(int[] value, boolean forceRgba) {
        int a;
        int b;
        int g;
        int r;
        if (value.length == 3) {
            r = value[0];
            g = value[1];
            b = value[2];
            a = 255;
        } else if (value.length == 4) {
            a = value[0];
            r = value[1];
            g = value[2];
            b = value[3];
        } else {
            throw new IllegalArgumentException("Unexpected shape of input: " + Arrays.toString(value));
        }
        if (forceRgba || a != 255) {
            return String.format("#%02X%02X%02X%02X", a, r, g, b);
        }
        return String.format("#%02X%02X%02X", r, g, b);
    }

    public static String toCode(int[] value) {
        return ColorUtil.toCode(value, false);
    }

    public static Color mix(Color fore, Color post, double weight) {
        return Color.rgb((int)((double)fore.red() * weight + (double)post.red() * (1.0 - weight)), (int)((double)fore.green() * weight + (double)post.green() * (1.0 - weight)), (int)((double)fore.blue() * weight + (double)post.blue() * (1.0 - weight)));
    }
}

