/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.neoforge.mixin.compat;

import io.homo.superresolution.api.platform.Platform;
import io.homo.superresolution.core.utils.MessageBox;
import io.homo.superresolution.neoforge.platform.NeoForgePlatform;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.neoforged.fml.loading.FMLConfig;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class CompatMixinPlugin
implements IMixinConfigPlugin {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"SuperResolution-Mixin");
    private final String CLASS_START = "io.homo.superresolution.neoforge.mixin.compat.";

    public void onLoad(String s) {
        Platform.currentPlatform = new NeoForgePlatform();
        Platform.currentPlatform.init();
        if (FMLConfig.getBoolConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_CONTROL)) {
            String infoZH = "SuperResolution\u9700\u8981\u8986\u76d6OpenGL\u7248\u672c\uff0c\u4f46\u7531\u4e8e\u4e00\u4e9b\u539f\u56e0\uff0c\u4f60\u9700\u8981\u5173\u95ed\u6e38\u620f\u5e76\u91cd\u65b0\u6253\u5f00\u5b83\uff1b\u5728\u521a\u521a\uff0cSuperResolution\u5df2\u7ecf\u628afml.toml\u4e2d\u7684earlyWindowControl\u4fee\u6539\u4e3afalse\uff0c\u8fd9\u5c06\u7981\u7528\u65e9\u671f\u52a0\u8f7d\u754c\u9762\uff0c\u4e0d\u8fc7\u4e0d\u7528\u62c5\u5fc3\uff0c\u8fd9\u53ea\u4f1a\u5bfc\u81f4\u6e38\u620f\u5728\u65e9\u671f\u52a0\u8f7d\u65f6\u4f60\u4ec0\u4e48\u4e5f\u770b\u4e0d\u5230\uff0c\u4f46\u8bf7\u6ce8\u610f\u4e0d\u8981\u628afml.toml\u4e2d\u7684earlyWindowControl\u4fee\u6539\u4e3atrue\uff0c\u8fd9\u4f1a\u5bfc\u81f4\u8fd9\u6761\u6d88\u606f\u518d\u6b21\u51fa\u73b0\u3002";
            String infoEN = "SuperResolution requires OpenGL version override, but due to technical constraints, you must close and restart the game. The earlyWindowControl setting in fml.toml has been automatically set to false, which disables the early loading screen. Rest assured, this only means you won't see visual feedback during initial loading phases. Please do NOT manually revert earlyWindowControl to true, as this will trigger this message again.";
            FMLConfig.updateConfig((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_CONTROL, (Object)false);
            LOGGER.info(infoZH);
            LOGGER.info(infoEN);
            MessageBox.createInfo("%s\n\n%s\n".formatted(infoZH, infoEN), "Info");
            System.exit(1);
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String s, String s1) {
        boolean b = this._shouldApplyMixin(s, s1);
        if (!b) {
            LOGGER.info("\u5df2\u7981\u7528Mixin {}", (Object)s1);
        } else {
            LOGGER.info("\u5df2\u542f\u7528Mixin {}", (Object)s1);
        }
        return b;
    }

    public boolean _shouldApplyMixin(String s, String s1) {
        String modid = s1.replace("io.homo.superresolution.neoforge.mixin.compat.", "").split("\\.")[0];
        if (Objects.equals(modid, "reesessodiumoptions")) {
            return Platform.currentPlatform.isModLoaded("reeses_sodium_options");
        }
        return Platform.currentPlatform.isModLoaded(modid);
    }

    public void acceptTargets(Set<String> set, Set<String> set1) {
    }

    public List<String> getMixins() {
        return List.of();
    }

    public void preApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }

    public void postApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }
}

