/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.test;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDirection;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaMeasureMode;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaNode;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaSize;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.test.NodeToString;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.test.PrintOptions;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.test.SerializedMeasureFunc;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CaptureTree {
    private static final ThreadLocal<Map<YogaNode, List<SerializedMeasureFunc>>> currentSerializedMeasureFuncMap = ThreadLocal.withInitial(HashMap::new);

    private static void captureTree(String serializedTree, Path path) {
        try {
            Files.writeString(path, (CharSequence)serializedTree, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write to file: " + String.valueOf(path), e);
        }
    }

    private static void dirtyTree(YogaNode node) {
        if (node.isMeasureDefined()) {
            node.markDirtyAndPropagate();
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            CaptureTree.dirtyTree(node.getChild(i));
        }
    }

    public static void calculateLayoutWithCapture(YogaNode node, float availableWidth, float availableHeight, YogaDirection ownerDirection, Path path) {
        CaptureTree.dirtyTree(node);
        node.calculateLayout(availableWidth, availableHeight, ownerDirection);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonObject jsonObject = new JsonObject();
        NodeToString.serializeLayoutInputs(jsonObject, availableWidth, availableHeight, ownerDirection);
        NodeToString.serializeTree(jsonObject, currentSerializedMeasureFuncMap.get(), node, EnumSet.of(PrintOptions.STYLE, PrintOptions.CHILDREN, PrintOptions.CONFIG, PrintOptions.NODE, PrintOptions.LAYOUT));
        currentSerializedMeasureFuncMap.get().clear();
        CaptureTree.captureTree(gson.toJson((JsonElement)jsonObject), path);
    }

    public static void captureMeasureFunc(YogaNode node, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode, YogaSize output, Duration duration) {
        Map<YogaNode, List<SerializedMeasureFunc>> map = currentSerializedMeasureFuncMap.get();
        List measureFuncs = map.computeIfAbsent(node, k -> new ArrayList());
        measureFuncs.add(new SerializedMeasureFunc(width, widthMode, height, heightMode, output.width(), output.height(), duration.toNanos()));
    }
}

