/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.config;

import com.mojang.blaze3d.systems.RenderSystem;
import io.homo.superresolution.api.AbstractAlgorithm;
import io.homo.superresolution.api.config.ModConfigSpec;
import io.homo.superresolution.api.config.ModConfigSpecBuilder;
import io.homo.superresolution.api.config.values.list.StringListValue;
import io.homo.superresolution.api.config.values.single.BooleanValue;
import io.homo.superresolution.api.config.values.single.EnumValue;
import io.homo.superresolution.api.config.values.single.FloatValue;
import io.homo.superresolution.api.config.values.single.StringValue;
import io.homo.superresolution.api.platform.OperatingSystem;
import io.homo.superresolution.api.platform.OperatingSystemType;
import io.homo.superresolution.api.platform.Platform;
import io.homo.superresolution.api.registry.AlgorithmDescription;
import io.homo.superresolution.api.registry.AlgorithmRegistry;
import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.config.enums.CaptureMode;
import io.homo.superresolution.common.config.enums.InternalTextureFormat;
import io.homo.superresolution.common.config.special.SpecialConfigs;
import io.homo.superresolution.common.minecraft.handler.RenderHandlerManager;
import io.homo.superresolution.common.minecraft.handler.SRShaderCompatConfig;
import io.homo.superresolution.common.minecraft.handler.ShaderCompatHandler;
import io.homo.superresolution.common.upscale.AlgorithmDescriptions;
import io.homo.superresolution.core.SuperResolutionConstants;
import io.homo.superresolution.core.graphics.GpuVendor;
import io.homo.superresolution.core.graphics.GraphicsCapabilities;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_310;
import org.lwjgl.opengl.GL;

public class SuperResolutionConfig {
    public static final ModConfigSpec SPEC;
    public static final SpecialConfigs SPECIAL;
    public static final BooleanValue ENABLE_UPSCALE;
    public static final FloatValue UPSCALE_RATIO;
    public static final StringValue UPSCALE_ALGO;
    public static final FloatValue SHARPNESS;
    public static final EnumValue<CaptureMode> CAPTURE_MODE;
    public static final BooleanValue DEBUG_DUMP_SHADER;
    public static final BooleanValue SKIP_INIT_VULKAN;
    public static final BooleanValue ENABLE_RENDER_DOC;
    public static final BooleanValue ENABLE_IMGUI;
    public static final BooleanValue GENERATE_MOTION_VECTORS;
    public static final BooleanValue PAUSE_GAME_ON_GUI;
    public static final StringListValue INJECT_POST_CHAIN_BLACKLIST;
    public static final BooleanValue ENABLE_COMPAT_SHADER_COMPILER;
    public static final BooleanValue ENABLE_DATASET_GENERATOR;
    public static final StringValue DATASET_PATH;
    public static final BooleanValue ENABLE_DETAILED_PROFILING;
    public static final BooleanValue ENABLE_DEBUG;
    public static final BooleanValue DISABLE_UPSCALE_ON_VANILLA;
    public static final BooleanValue FORCE_DISABLE_SHADER_COMPAT;
    public static final EnumValue<InternalTextureFormat> INTERNAL_TEXTURE_FORMAT;
    public static final OperatingSystemType CURRENT_OS_TYPE;
    public static final Runnable resolutionChangeCallback;

    public static AlgorithmDescription<?> getDefaultAlgorithm() {
        try {
            GL.getCapabilities();
        }
        catch (Exception e) {
            return AlgorithmDescriptions.SGSR1;
        }
        for (AlgorithmDescription<?> algorithmDescription : AlgorithmRegistry.getAlgorithmMap().values()) {
            if (!algorithmDescription.requirement.check().support()) continue;
            return algorithmDescription;
        }
        SuperResolution.LOGGER.info("\u4f60\u7684\u786c\u4ef6\u4e0d\u652f\u6301\u6240\u6709\u7b97\u6cd5????");
        return AlgorithmDescriptions.NONE;
    }

    public static float getRenderScaleFactor() {
        return (Boolean)ENABLE_UPSCALE.get() != false ? 1.0f / ((Float)UPSCALE_RATIO.get()).floatValue() : 1.0f;
    }

    public static AlgorithmDescription<?> getUpscaleAlgorithm() {
        String algoName = (String)UPSCALE_ALGO.get();
        AlgorithmDescription<?> algo = AlgorithmRegistry.getDescriptionByID(algoName);
        if (algo == null) {
            algo = SuperResolutionConfig.getDefaultAlgorithm();
            UPSCALE_ALGO.set(algo.codeName);
        }
        if (!algo.requirement.check().support() && !Platform.currentPlatform.isDevelopmentEnvironment()) {
            SuperResolution.LOGGER.warn("\u7b97\u6cd5 {} \u4e0d\u652f\u6301\uff0c\u56de\u9000\u5230\u9ed8\u8ba4\u7b97\u6cd5", (Object)algo.displayName);
            AlgorithmDescription<?> defaultAlgo = SuperResolutionConfig.getDefaultAlgorithm();
            SuperResolutionConfig.setUpscaleAlgorithm(defaultAlgo);
            return defaultAlgo;
        }
        return algo;
    }

    public static synchronized void setUpscaleAlgorithm(AlgorithmDescription<?> newAlgo) {
        block11: {
            String algoName;
            AlgorithmDescription<?> currentAlgo;
            if (newAlgo == null) {
                newAlgo = SuperResolutionConfig.getDefaultAlgorithm();
            }
            if ((currentAlgo = AlgorithmRegistry.getDescriptionByID(algoName = (String)UPSCALE_ALGO.get())) == newAlgo) {
                return;
            }
            AbstractAlgorithm oldAlgorithmInstance = SuperResolution.currentAlgorithm;
            AlgorithmDescription<?> oldDescription = SuperResolution.algorithmDescription;
            try {
                UPSCALE_ALGO.set(newAlgo.codeName);
                SuperResolution.algorithmDescription = newAlgo;
                if (!SuperResolution.createAlgorithm()) {
                    throw new RuntimeException("\u521b\u5efa\u7b97\u6cd5\u5931\u8d25");
                }
                if (oldAlgorithmInstance != null) {
                    try {
                        oldAlgorithmInstance.destroy();
                    }
                    catch (Exception e) {
                        SuperResolution.LOGGER.error("\u9500\u6bc1\u65e7\u7b97\u6cd5\u65f6\u51fa\u9519", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                SuperResolution.LOGGER.error("\u5207\u6362\u5230\u7b97\u6cd5 {} \u5931\u8d25\uff0c\u5c1d\u8bd5\u56de\u6eda", (Object)newAlgo.displayName, (Object)e);
                UPSCALE_ALGO.set(oldDescription != null ? oldDescription.codeName : AlgorithmDescriptions.NONE.codeName);
                SuperResolution.algorithmDescription = oldDescription;
                SuperResolution.currentAlgorithm = oldAlgorithmInstance;
                if (oldAlgorithmInstance != null || oldDescription == null) break block11;
                try {
                    if (!SuperResolution.createAlgorithm()) {
                        SuperResolutionConfig.fallbackToNone();
                    }
                }
                catch (Exception ex) {
                    SuperResolutionConfig.fallbackToNone();
                }
            }
        }
    }

    private static void fallbackToNone() {
        SuperResolution.LOGGER.error("\u6240\u6709\u56de\u6eda\u5c1d\u8bd5\u5931\u8d25\uff0c\u4f7f\u7528NONE\u7b97\u6cd5");
        UPSCALE_ALGO.set(AlgorithmDescriptions.NONE.codeName);
        SuperResolution.algorithmDescription = AlgorithmDescriptions.NONE;
        SuperResolution.createAlgorithm();
    }

    public static boolean isEnableUpscaleOriginal() {
        return (Boolean)ENABLE_UPSCALE.get();
    }

    public static boolean isEnableUpscale() {
        if (SuperResolutionConfig.isDisableUpscaleOnVanilla()) {
            return SuperResolutionConfig.isEnableUpscaleOriginal() && ShaderCompatHandler.irisApiIsShaderPackInUse();
        }
        return SuperResolutionConfig.isEnableUpscaleOriginal();
    }

    public static void setEnableUpscale(boolean value) {
        boolean resolutionChanged = SuperResolutionConfig.isEnableUpscale() != value;
        ENABLE_UPSCALE.set(value);
        if (resolutionChanged) {
            resolutionChangeCallback.run();
        }
    }

    public static float getSharpness() {
        return ((Float)SHARPNESS.get()).floatValue();
    }

    public static void setSharpness(float value) {
        SHARPNESS.set(Float.valueOf(value));
    }

    public static CaptureMode getCaptureMode() {
        return (CaptureMode)((Object)CAPTURE_MODE.get());
    }

    public static void setCaptureMode(CaptureMode value) {
        CAPTURE_MODE.set((Object)value);
    }

    public static float getUpscaleRatio() {
        return ((Float)UPSCALE_RATIO.get()).floatValue();
    }

    public static void setUpscaleRatio(float value) {
        boolean resolutionChanged = SuperResolutionConfig.getUpscaleRatio() != value;
        UPSCALE_RATIO.set(Float.valueOf(value));
        if (resolutionChanged) {
            resolutionChangeCallback.run();
        }
    }

    public static boolean isDebugDumpShader() {
        return (Boolean)DEBUG_DUMP_SHADER.get();
    }

    public static void setDebugDumpShader(boolean value) {
        DEBUG_DUMP_SHADER.set(value);
    }

    public static boolean isSkipInitVulkan() {
        return (Boolean)SKIP_INIT_VULKAN.get();
    }

    public static void setSkipInitVulkan(boolean value) {
        SKIP_INIT_VULKAN.set(value);
    }

    public static boolean isEnableRenderDoc() {
        return (Boolean)ENABLE_RENDER_DOC.get();
    }

    public static void setEnableRenderDoc(boolean value) {
        ENABLE_RENDER_DOC.set(value);
    }

    public static boolean isEnableImgui() {
        return (Boolean)ENABLE_IMGUI.get();
    }

    public static void setEnableImgui(boolean value) {
        ENABLE_IMGUI.set(value);
    }

    public static boolean isGenerateMotionVectors() {
        return (Boolean)GENERATE_MOTION_VECTORS.get();
    }

    public static void setGenerateMotionVectors(boolean value) {
        GENERATE_MOTION_VECTORS.set(value);
    }

    public static boolean isPauseGameOnGui() {
        return (Boolean)PAUSE_GAME_ON_GUI.get();
    }

    public static void setPauseGameOnGui(boolean value) {
        PAUSE_GAME_ON_GUI.set(value);
    }

    public static List<String> getInjectPostChainBlackList() {
        return (List)INJECT_POST_CHAIN_BLACKLIST.get();
    }

    public static void setInjectPostChainBlackList(List<String> value) {
        INJECT_POST_CHAIN_BLACKLIST.set(value);
    }

    public static void setEnableCompatShaderCompiler(boolean value) {
        ENABLE_COMPAT_SHADER_COMPILER.set(value);
    }

    public static boolean isEnableCompatShaderCompiler() {
        return false;
    }

    public static void setEnableDatasetGenerator(boolean value) {
        ENABLE_DATASET_GENERATOR.set(value);
    }

    public static boolean isEnableDatasetGenerator() {
        return (Boolean)ENABLE_DATASET_GENERATOR.get();
    }

    public static boolean isEnableDetailedProfiling() {
        return (Boolean)ENABLE_DETAILED_PROFILING.get();
    }

    public static void setEnableDetailedProfiling(boolean value) {
        ENABLE_DETAILED_PROFILING.set(value);
    }

    public static boolean isEnableDebug() {
        return (Boolean)ENABLE_DEBUG.get();
    }

    public static void setEnableDebug(boolean value) {
        ENABLE_DEBUG.set(value);
    }

    public static boolean isForceDisableShaderCompat() {
        return (Boolean)FORCE_DISABLE_SHADER_COMPAT.get();
    }

    public static void setForceDisableShaderCompat(boolean value) {
        FORCE_DISABLE_SHADER_COMPAT.set(value);
    }

    public static boolean isDisableUpscaleOnVanilla() {
        return (Boolean)DISABLE_UPSCALE_ON_VANILLA.get();
    }

    public static void setDisableUpscaleOnVanilla(boolean value) {
        DISABLE_UPSCALE_ON_VANILLA.set(value);
    }

    public static void setInternalTextureFormat(InternalTextureFormat format) {
        INTERNAL_TEXTURE_FORMAT.set((Object)format);
    }

    public static String getInternalTextureFormatGlslFormatQualifier() {
        return switch (SuperResolutionConfig.getInternalTextureFormat()) {
            case TextureFormat.RGBA8 -> "rgba8";
            case TextureFormat.RGBA16F -> "rgba16f";
            case TextureFormat.RGBA16 -> "rgba16";
            case TextureFormat.R11G11B10F -> "r11f_g11f_b10f";
            default -> "r11f_g11f_b10f";
        };
    }

    public static TextureFormat getInternalTextureFormat() {
        if (INTERNAL_TEXTURE_FORMAT.get() == InternalTextureFormat.AUTO) {
            Optional<SRShaderCompatConfig.WorldConfig> currentLevelCompatConfig = ShaderCompatHandler.getCurrentLevelCompatConfig();
            if (currentLevelCompatConfig.isPresent() && currentLevelCompatConfig.get().enabled) {
                return currentLevelCompatConfig.get().upscale_config.getSrInternalTextureFormat();
            }
            return TextureFormat.R11G11B10F;
        }
        return ((InternalTextureFormat)((Object)INTERNAL_TEXTURE_FORMAT.get())).format();
    }

    public static float getMinUpscaleRatio() {
        if (ShaderCompatHandler.isShaderPackCompatSuperResolution()) {
            return 1.0f;
        }
        return 0.5f;
    }

    static {
        CURRENT_OS_TYPE = new OperatingSystem().type;
        ModConfigSpecBuilder builder = new ModConfigSpecBuilder();
        Supplier<String> defaultAlgoSupplier = () -> SuperResolutionConfig.getDefaultAlgorithm().codeName;
        ENABLE_UPSCALE = builder.defineBoolean("enable_upscale", () -> true, "Enable super-resolution upscaling");
        UPSCALE_RATIO = builder.defineFloat("upscale_ratio", () -> Float.valueOf(1.7f), "Upscale ratio factor", value -> value.floatValue() >= 0.5f && value.floatValue() <= 4.0f);
        UPSCALE_ALGO = builder.defineString("upscale_algo", defaultAlgoSupplier, "Algorithm used for upscaling", value -> {
            if (value == null) {
                return false;
            }
            AlgorithmDescription<?> algo = AlgorithmRegistry.getDescriptionByID(value);
            return algo != null;
        });
        SHARPNESS = builder.defineFloat("sharpness", () -> Float.valueOf(0.55f), "Sharpness adjustment factor", value -> value.floatValue() >= 0.0f && value.floatValue() <= 1.0f);
        CAPTURE_MODE = builder.defineEnum("capture_mode", CaptureMode.class, () -> CaptureMode.A, "Screen capture mode");
        PAUSE_GAME_ON_GUI = builder.defineBoolean("pause_game_on_gui", () -> false, "Pause game when GUI is open");
        INJECT_POST_CHAIN_BLACKLIST = builder.defineStringList("inject_post_chain_blacklist", ArrayList::new, "List of post-processing chains to skip injection", value -> value != null && !value.isEmpty());
        DEBUG_DUMP_SHADER = builder.defineBoolean("debug/debug_dump_shader", () -> false, "Dump shaders for debugging purposes");
        SKIP_INIT_VULKAN = builder.defineBoolean("debug/skip_init_vulkan", () -> CURRENT_OS_TYPE != OperatingSystemType.ANDROID && CURRENT_OS_TYPE != OperatingSystemType.MACOS, "Skip Vulkan initialization (auto-set based on OS)");
        ENABLE_RENDER_DOC = builder.defineBoolean("debug/enable_render_doc", () -> (CURRENT_OS_TYPE == OperatingSystemType.WINDOWS || CURRENT_OS_TYPE == OperatingSystemType.LINUX) && Platform.currentPlatform.isDevelopmentEnvironment(), "Enable RenderDoc integration (auto-disabled on incompatible OS)");
        ENABLE_IMGUI = builder.defineBoolean("debug/enable_imgui", () -> (CURRENT_OS_TYPE == OperatingSystemType.WINDOWS || CURRENT_OS_TYPE == OperatingSystemType.LINUX) && Platform.currentPlatform.isDevelopmentEnvironment(), "Enable ImGui debug interface (auto-disabled on incompatible OS)");
        ENABLE_DEBUG = builder.defineBoolean("debug/enable_debug", () -> false, "Enable debug mode");
        GENERATE_MOTION_VECTORS = builder.defineBoolean("experiment/generate_motion_vectors", () -> false, "Generate motion vectors for advanced effects");
        ENABLE_COMPAT_SHADER_COMPILER = builder.defineBoolean("compat_shader_compiler", () -> {
            try {
                if (GL.getCapabilities() == null) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            return RenderSystem.isOnRenderThread() ? GraphicsCapabilities.detectGpuVendor() == GpuVendor.Intel || !GraphicsCapabilities.hasGLExtension("GL_ARB_gl_spirv") || GraphicsCapabilities.getGLVersion()[0] >= 4 && GraphicsCapabilities.getGLVersion()[1] < 2 : false;
        }, "This option enables the use of a compatibility shader compiler for compiling shaders when set to true.");
        ENABLE_DATASET_GENERATOR = builder.defineBoolean("dataset/enable_dataset_generator", () -> false, "");
        DATASET_PATH = builder.defineString("dataset/dataset_path", () -> "msrDataset", "");
        ENABLE_DETAILED_PROFILING = builder.defineBoolean("debug/enable_detailed_profiling", () -> false, "Enable more detailed performance profiling for advanced analysis.");
        FORCE_DISABLE_SHADER_COMPAT = builder.defineBoolean("force_disable_shader_compat", () -> false, "Force disable shader pack compatibility mode.");
        DISABLE_UPSCALE_ON_VANILLA = builder.defineBoolean("disable_upscale_on_vanilla", () -> false, "Disable Super Resolution when using vanilla rendering.");
        INTERNAL_TEXTURE_FORMAT = builder.defineEnum("internal_texture_format", InternalTextureFormat.class, () -> InternalTextureFormat.R11B11G10F, "The precision of the internal texture format affects video memory consumption: higher precision results in greater consumption, while lower precision leads to smaller consumption. Note: Excessively low precision may cause noticeable color banding in the image.");
        SPECIAL = new SpecialConfigs(builder);
        Path configPath = SuperResolutionConstants.CONFIG_FILE;
        builder.configPath(configPath);
        SPEC = builder.build();
        resolutionChangeCallback = () -> {
            RenderHandlerManager.resize();
            SuperResolution.getInstance().resize(RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight());
            class_310.method_1551().field_1773.method_3169(RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight());
        };
    }
}

