/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.gui.impl;

import com.google.common.collect.Maps;
import io.homo.superresolution.common.gui.impl.ClothConfigCategoryImpl;
import io.homo.superresolution.common.gui.screens.ClothStyleConfigScreen;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;

public class ClothConfigBuilder
implements ConfigBuilder {
    private final Map<String, ConfigCategory> categoryMap = Maps.newLinkedHashMap();
    private Runnable savingRunnable;
    private class_437 parent;
    private class_2561 title = class_2561.method_43471((String)"text.cloth-config.config");
    private boolean editable = true;
    private boolean tabsSmoothScroll = true;
    private boolean listSmoothScroll = true;
    private boolean doesConfirmSave = true;
    private boolean transparentBackground = true;
    private boolean enableSearch = true;
    private class_2960 defaultBackground = class_437.field_44669;
    private Consumer<class_437> afterInitConsumer = screen -> {};
    private String fallbackCategory = null;
    private boolean alwaysShowTabs = false;

    public ClothConfigBuilder setEnableSearch(boolean enableSearch) {
        this.enableSearch = enableSearch;
        return this;
    }

    public void setGlobalizedExpanded(boolean globalizedExpanded) {
    }

    public boolean isAlwaysShowTabs() {
        return this.alwaysShowTabs;
    }

    public ClothConfigBuilder setAlwaysShowTabs(boolean alwaysShowTabs) {
        this.alwaysShowTabs = alwaysShowTabs;
        return this;
    }

    public ClothConfigBuilder setTransparentBackground(boolean transparentBackground) {
        this.transparentBackground = transparentBackground;
        return this;
    }

    public boolean hasTransparentBackground() {
        return this.transparentBackground;
    }

    public void setGlobalized(boolean b) {
    }

    public ClothConfigBuilder setFallbackCategory(ConfigCategory fallbackCategory) {
        this.fallbackCategory = Objects.requireNonNull(fallbackCategory).getCategoryKey().getString();
        return this;
    }

    public class_437 getParentScreen() {
        return this.parent;
    }

    public ClothConfigBuilder setParentScreen(class_437 parent) {
        this.parent = parent;
        return this;
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public ClothConfigBuilder setTitle(class_2561 title) {
        this.title = title;
        return this;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public ClothConfigBuilder setEditable(boolean editable) {
        this.editable = editable;
        return this;
    }

    public ConfigCategory getOrCreateCategory(class_2561 categoryKey) {
        if (this.categoryMap.containsKey(categoryKey.getString())) {
            return this.categoryMap.get(categoryKey.getString());
        }
        if (this.fallbackCategory == null) {
            this.fallbackCategory = categoryKey.getString();
        }
        return this.categoryMap.computeIfAbsent(categoryKey.getString(), key -> new ClothConfigCategoryImpl(this, categoryKey));
    }

    public ClothConfigBuilder removeCategory(class_2561 category) {
        if (this.categoryMap.containsKey(category.getString()) && Objects.equals(this.fallbackCategory, category.getString())) {
            this.fallbackCategory = null;
        }
        if (!this.categoryMap.containsKey(category.getString())) {
            throw new NullPointerException("Category doesn't exist!");
        }
        this.categoryMap.remove(category.getString());
        return this;
    }

    public ClothConfigBuilder removeCategoryIfExists(class_2561 category) {
        if (this.categoryMap.containsKey(category.getString()) && Objects.equals(this.fallbackCategory, category.getString())) {
            this.fallbackCategory = null;
        }
        this.categoryMap.remove(category.getString());
        return this;
    }

    public boolean hasCategory(class_2561 category) {
        return this.categoryMap.containsKey(category.getString());
    }

    public ClothConfigBuilder setShouldTabsSmoothScroll(boolean shouldTabsSmoothScroll) {
        this.tabsSmoothScroll = shouldTabsSmoothScroll;
        return this;
    }

    public boolean isTabsSmoothScrolling() {
        return this.tabsSmoothScroll;
    }

    public ClothConfigBuilder setShouldListSmoothScroll(boolean shouldListSmoothScroll) {
        this.listSmoothScroll = shouldListSmoothScroll;
        return this;
    }

    public boolean isListSmoothScrolling() {
        return this.listSmoothScroll;
    }

    public ClothConfigBuilder setDoesConfirmSave(boolean confirmSave) {
        this.doesConfirmSave = confirmSave;
        return this;
    }

    public boolean doesConfirmSave() {
        return this.doesConfirmSave;
    }

    public class_2960 getDefaultBackgroundTexture() {
        return this.defaultBackground;
    }

    public ClothConfigBuilder setDefaultBackgroundTexture(class_2960 texture) {
        this.defaultBackground = texture;
        return this;
    }

    public Consumer<class_437> getAfterInitConsumer() {
        return this.afterInitConsumer;
    }

    public ClothConfigBuilder setAfterInitConsumer(Consumer<class_437> afterInitConsumer) {
        this.afterInitConsumer = afterInitConsumer;
        return this;
    }

    public class_437 build() {
        throw new RuntimeException();
    }

    public class_437 build(Class<? extends ClothStyleConfigScreen> clazz) {
        if (!this.categoryMap.isEmpty() && this.fallbackCategory != null) {
            ClothStyleConfigScreen screen;
            try {
                Constructor<? extends ClothStyleConfigScreen> constructor = clazz.getDeclaredConstructor(class_437.class, class_2561.class, Map.class, class_2960.class);
                screen = constructor.newInstance(this.parent, this.title, this.categoryMap, this.defaultBackground);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            screen.setSavingRunnable(this.savingRunnable);
            screen.setEditable(this.editable);
            screen.setFallbackCategory((class_2561)(this.fallbackCategory == null ? null : class_2561.method_43470((String)this.fallbackCategory)));
            screen.setTransparentBackground(this.transparentBackground);
            screen.setAlwaysShowTabs(this.alwaysShowTabs);
            screen.setConfirmSave(this.doesConfirmSave);
            screen.setEnableSearch(this.enableSearch);
            screen.setAfterInitConsumer(this.afterInitConsumer);
            return screen;
        }
        throw new NullPointerException("There cannot be no categories or fallback category!");
    }

    public Runnable getSavingRunnable() {
        return this.savingRunnable;
    }

    public ClothConfigBuilder setSavingRunnable(Runnable runnable) {
        this.savingRunnable = runnable;
        return this;
    }
}

