/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl;

import io.homo.superresolution.core.graphics.impl.device.IDevice;
import io.homo.superresolution.core.graphics.impl.vertex.IVertexArray;
import io.homo.superresolution.core.graphics.impl.vertex.IVertexBuffer;
import io.homo.superresolution.core.graphics.impl.vertex.PrimitiveType;
import io.homo.superresolution.core.graphics.impl.vertex.VertexAttribute;
import io.homo.superresolution.core.graphics.impl.vertex.VertexBufferDescription;
import io.homo.superresolution.core.graphics.opengl.vertex.GlVertexArray;
import io.homo.superresolution.core.impl.Destroyable;

public class DrawObject
implements Destroyable {
    private final IVertexBuffer vertexBuffer;
    private final IVertexArray vertexArray;
    private final PrimitiveType primitiveType;
    private boolean once;
    private static DrawObject fullscreenQuadInstance;

    public DrawObject(IVertexBuffer vertexBuffer, IVertexArray vertexArray, PrimitiveType primitiveType) {
        this.vertexBuffer = vertexBuffer;
        this.vertexArray = vertexArray;
        this.primitiveType = primitiveType;
    }

    public static int fullscreenQuadVertexCount() {
        return 4;
    }

    public static DrawObject fullscreenQuad(IDevice device) {
        float[] vertices = new float[]{-1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f};
        VertexBufferDescription desc = new VertexBufferDescription(vertices.length * 4, false);
        IVertexBuffer vbo = device.createVertexBuffer(desc);
        vbo.updateData(vertices, 0, vertices.length);
        VertexAttribute[] attributes = new VertexAttribute[]{new VertexAttribute(0, 2, VertexAttribute.DataType.FLOAT, 16, 0), new VertexAttribute(1, 2, VertexAttribute.DataType.FLOAT, 16, 8)};
        GlVertexArray vao = new GlVertexArray();
        vao.setAttributes(attributes, vbo);
        return new DrawObject(vbo, vao, PrimitiveType.TriangleStrip);
    }

    public PrimitiveType getPrimitiveType() {
        return this.primitiveType;
    }

    public IVertexArray getVertexArray() {
        return this.vertexArray;
    }

    public IVertexBuffer getVertexBuffer() {
        return this.vertexBuffer;
    }

    public boolean isOnce() {
        return this.once;
    }

    public DrawObject once() {
        this.once = true;
        return this;
    }

    @Override
    public void destroy() {
        this.vertexBuffer.destroy();
        this.vertexArray.destroy();
    }

    public void close() {
        this.destroy();
    }
}

