/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl.shader;

import io.homo.superresolution.core.graphics.impl.shader.ShaderSource;
import io.homo.superresolution.core.graphics.impl.shader.ShaderType;
import io.homo.superresolution.core.graphics.impl.shader.uniform.ShaderUniformAccess;
import io.homo.superresolution.core.graphics.impl.shader.uniform.ShaderUniformDescription;
import io.homo.superresolution.core.graphics.impl.shader.uniform.ShaderUniformType;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class ShaderDescription {
    protected final EnumMap<ShaderType, ShaderSource> sourceMap = new EnumMap(ShaderType.class);
    protected final Map<String, String> definesMap = new HashMap<String, String>();
    protected final Map<String, ShaderUniformDescription> shaderUniforms = new HashMap<String, ShaderUniformDescription>();
    protected String shaderName = UUID.randomUUID().toString();

    public static Builder graphics(ShaderSource fragment, ShaderSource vertex) {
        return new Builder().fragment(fragment).vertex(vertex);
    }

    public static Builder compute(ShaderSource compute) {
        return new Builder().compute(compute);
    }

    public static Builder create() {
        return new Builder();
    }

    public EnumMap<ShaderType, ShaderSource> sourceMap() {
        return this.sourceMap;
    }

    public Map<String, String> definesMap() {
        return this.definesMap;
    }

    public Map<String, ShaderUniformDescription> shaderUniforms() {
        return this.shaderUniforms;
    }

    public String shaderName() {
        return this.shaderName;
    }

    public ShaderSource fragment() {
        return this.sourceMap.get((Object)ShaderType.Fragment);
    }

    public ShaderSource vertex() {
        return this.sourceMap.get((Object)ShaderType.Vertex);
    }

    public ShaderSource compute() {
        return this.sourceMap.get((Object)ShaderType.Compute);
    }

    protected void updateShaderSource() {
        this.sourceMap.values().forEach(source -> source.addDefines(this.definesMap));
        this.sourceMap.values().forEach(ShaderSource::updateSource);
    }

    public static class Builder {
        private final ShaderDescription description = new ShaderDescription();

        protected Builder() {
        }

        public Builder uniformBuffer(String name, int binding, int bufferSize) {
            return this.uniform(ShaderUniformDescription.builder(name, ShaderUniformType.UniformBuffer).binding(binding).bufferSize(bufferSize).build());
        }

        public Builder uniformSamplerTexture(String name, int binding) {
            return this.uniform(ShaderUniformDescription.builder(name, ShaderUniformType.SamplerTexture).binding(binding).build());
        }

        public Builder uniformStorageTexture(String name, ShaderUniformAccess access, int binding) {
            return this.uniform(ShaderUniformDescription.builder(name, ShaderUniformType.StorageTexture).binding(binding).access(access).build());
        }

        public Builder uniformStorageTexture(String name, int binding) {
            return this.uniform(ShaderUniformDescription.builder(name, ShaderUniformType.StorageTexture).binding(binding).access(ShaderUniformAccess.Both).build());
        }

        public ShaderSource fragmentSource() {
            return this.description.fragment();
        }

        public ShaderSource vertexSource() {
            return this.description.vertex();
        }

        public ShaderSource computeSource() {
            return this.description.compute();
        }

        public Builder fragment(ShaderSource source) {
            if (source.getType() != ShaderType.Fragment) {
                throw new RuntimeException();
            }
            this.description.sourceMap.put(ShaderType.Fragment, source);
            return this;
        }

        public Builder vertex(ShaderSource source) {
            if (source.getType() != ShaderType.Vertex) {
                throw new RuntimeException();
            }
            this.description.sourceMap.put(ShaderType.Vertex, source);
            return this;
        }

        public Builder compute(ShaderSource source) {
            if (source.getType() != ShaderType.Compute) {
                throw new RuntimeException();
            }
            this.description.sourceMap.put(ShaderType.Compute, source);
            return this;
        }

        public Builder addDefine(String key, String value) {
            this.description.definesMap.put(key, value);
            return this;
        }

        public Builder addDefines(Map<String, String> map) {
            this.description.definesMap.putAll(map);
            return this;
        }

        public Builder uniform(ShaderUniformDescription uniform) {
            this.description.shaderUniforms.put(uniform.name(), uniform);
            return this;
        }

        public Builder name(String name) {
            this.description.shaderName = name;
            return this;
        }

        public ShaderDescription build() {
            this.description.updateShaderSource();
            return this.description;
        }
    }
}

