/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui;

import io.homo.superresolution.core.gui.core.AbstractWidget;
import io.homo.superresolution.core.gui.core.UIInputState;
import io.homo.superresolution.core.gui.core.backends.interfaces.IUIDrawContext;
import io.homo.superresolution.core.gui.core.backends.nanovg.NanoVG;
import io.homo.superresolution.core.gui.core.backends.nanovg.NanoVGContext;
import io.homo.superresolution.core.gui.core.backends.nanovg.NanoVGDrawContext;
import io.homo.superresolution.core.gui.core.event.GuiEventListener;
import io.homo.superresolution.core.gui.core.impl.Renderable;
import io.homo.superresolution.core.utils.MouseCursor;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2f;

public abstract class NanoVGScreen<T>
extends class_437 {
    protected final NanoVGContext nvg;
    protected final ArrayList<Renderable> renderable = new ArrayList();
    protected final ArrayList<GuiEventListener> eventListener = new ArrayList();
    protected final ArrayList<AbstractWidget<?, ?, ?>> widget = new ArrayList();
    protected boolean transparent = false;

    protected NanoVGScreen(class_2561 title) {
        super(title);
        this.nvg = NanoVG.context;
        this.buildWidgets();
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public NanoVGScreen setTransparent(boolean transparent) {
        this.transparent = transparent;
        return this;
    }

    protected abstract void buildWidgets();

    public void method_25419() {
        super.method_25419();
        MouseCursor.ARROW.use();
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX_, int mouseY_, float partialTick) {
        float mouseX = (float)(class_310.method_1551().method_22683().method_4495() * (double)mouseX_);
        float mouseY = (float)(class_310.method_1551().method_22683().method_4495() * (double)mouseY_);
        this.drawBefore(guiGraphics, (int)mouseX, (int)mouseY, partialTick);
        this.nvg.begin(this.transparent);
        this.nvg.resetGlobalTransform();
        this.nvg.resetTransform();
        this.nvg.globalAlpha(1.0f);
        NanoVGDrawContext drawContext = new NanoVGDrawContext(this.nvg);
        this.draw(drawContext, new UIInputState(new Vector2f(mouseX, mouseY), partialTick));
        drawContext.drawAll();
        this.nvg.end();
        this.drawAfter(guiGraphics, (int)mouseX, (int)mouseY, partialTick);
    }

    protected void method_25426() {
        super.method_25426();
    }

    public void method_25410(@NotNull class_310 minecraft, int width, int height) {
        super.method_25410(minecraft, width, height);
    }

    public void draw(IUIDrawContext drawContext, UIInputState inputState) {
        this.drawBefore(drawContext, inputState);
        this.drawWidgets(drawContext, inputState);
        this.drawTooltips(drawContext, inputState);
        this.drawAfter(drawContext, inputState);
    }

    public void drawTooltips(IUIDrawContext drawContext, UIInputState inputState) {
    }

    public void drawAfter(IUIDrawContext drawContext, UIInputState inputState) {
    }

    public void drawBefore(IUIDrawContext drawContext, UIInputState inputState) {
    }

    public void drawAfter(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
    }

    public void drawBefore(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
    }

    public void drawWidgets(IUIDrawContext drawContext, UIInputState inputState) {
        Map layers = Stream.concat(this.renderable.stream(), this.widget.stream()).collect(Collectors.groupingBy(Renderable::getZIndex, TreeMap::new, Collectors.toList()));
        layers.values().forEach(layer -> layer.forEach(r -> r.render(drawContext, inputState)));
    }

    protected void method_37067() {
        super.method_37067();
        this.renderable.clear();
        this.widget.clear();
        this.eventListener.clear();
    }

    protected void removeWidget(Object widget) {
        if (widget instanceof Renderable) {
            this.renderable.remove(widget);
        }
        if (widget instanceof AbstractWidget) {
            this.widget.remove(widget);
        }
        if (widget instanceof GuiEventListener) {
            this.eventListener.remove(widget);
        }
    }

    protected <T extends AbstractWidget<?, ?, ?>> T addWidget(T w) {
        this.widget.add(w);
        this.eventListener.add(w);
        return w;
    }

    protected void method_41843() {
    }

    protected <T extends Renderable> T addRenderableOnly(T renderable) {
        this.renderable.add(renderable);
        return renderable;
    }

    protected <T extends AbstractWidget<?, ?, ?>> T addRenderableWidget(T widget) {
        this.renderable.add(widget);
        this.eventListener.add(widget);
        return widget;
    }

    protected void invokeEventHandle(Consumer<GuiEventListener> consumer) {
        for (GuiEventListener handle : this.eventListener) {
            consumer.accept(handle);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.invokeEventHandle(handle -> handle.mousePress((float)this.transformPos(mouseX), (float)this.transformPos(mouseY), button));
        super.method_25402(mouseX, mouseY, button);
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.invokeEventHandle(handle -> handle.mouseRelease((float)this.transformPos(mouseX), (float)this.transformPos(mouseY), button));
        super.method_25406(mouseX, mouseY, button);
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.invokeEventHandle(handle -> handle.mouseDrag((float)this.transformPos(mouseX), (float)this.transformPos(mouseY), (float)this.transformPos(dragX), (float)this.transformPos(dragY), button));
        super.method_25403(mouseX, mouseY, button, dragX, dragY);
        return true;
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        this.invokeEventHandle(handle -> handle.keyRelease(keyCode, scanCode, modifiers));
        super.method_16803(keyCode, scanCode, modifiers);
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        this.invokeEventHandle(handle -> handle.keyPress(keyCode, scanCode, modifiers));
        super.method_25404(keyCode, scanCode, modifiers);
        return true;
    }

    public boolean method_25400(char codePoint, int modifiers) {
        this.invokeEventHandle(handle -> handle.charTyped(codePoint, modifiers));
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX) {
        this.invokeEventHandle(handle -> handle.mouseScroll((float)this.transformPos(mouseX), (float)this.transformPos(mouseY), (float)this.transformPos(scrollX)));
        super.method_25401(mouseX, mouseY, scrollX);
        return true;
    }

    public void method_16014(double mouseX, double mouseY) {
        this.invokeEventHandle(handle -> handle.mouseMove((float)this.transformPos(mouseX), (float)this.transformPos(mouseY)));
        super.method_16014(mouseX, mouseY);
    }

    protected double transformPos(double pos) {
        return class_310.method_1551().method_22683().method_4495() * pos / (double)this.nvg.globalScale();
    }
}

