/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.core.backends.nanovg.commands;

import io.homo.superresolution.core.gui.core.backends.interfaces.DrawCommandType;
import io.homo.superresolution.core.gui.core.backends.interfaces.IFont;
import io.homo.superresolution.core.gui.core.backends.interfaces.TextAlign;
import io.homo.superresolution.core.gui.core.backends.nanovg.NanoVGContext;
import io.homo.superresolution.core.gui.core.backends.nanovg.NanoVGTextRenderer;
import io.homo.superresolution.core.gui.core.backends.nanovg.commands.NVGDrawCommand;
import io.homo.superresolution.core.utils.Color;

public class NVGDrawTextCommand
extends NVGDrawCommand {
    protected final IFont font;
    protected final float fontSize;
    protected final String text;
    protected final float startX;
    protected final float startY;
    protected final float maxWidth;
    protected final float lineHeight;
    protected final Color color;
    protected final TextAlign align;
    protected final boolean wrap;

    public NVGDrawTextCommand(NanoVGContext context, IFont font, float fontSize, String text, float startX, float startY, float maxWidth, float lineHeight, Color color, TextAlign align, boolean wrap) {
        super(context, DrawCommandType.DrawText);
        this.font = font;
        this.fontSize = fontSize;
        this.text = text;
        this.startX = startX;
        this.startY = startY;
        this.maxWidth = maxWidth;
        this.lineHeight = lineHeight;
        this.color = color;
        this.align = align;
        this.wrap = wrap;
    }

    @Override
    protected void execute() {
        NanoVGTextRenderer.INSTANCE.drawAlignedText(this.font, this.fontSize, this.text, this.startX, this.startY, this.maxWidth, this.lineHeight, this.color, this.align, this.wrap);
    }

    public IFont font() {
        return this.font;
    }

    public float fontSize() {
        return this.fontSize;
    }

    public String text() {
        return this.text;
    }

    public float startX() {
        return this.startX;
    }

    public float startY() {
        return this.startY;
    }

    public float maxWidth() {
        return this.maxWidth;
    }

    public float lineHeight() {
        return this.lineHeight;
    }

    public Color color() {
        return this.color;
    }

    public TextAlign align() {
        return this.align;
    }

    public boolean wrap() {
        return this.wrap;
    }
}

