/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.srapi;

import java.util.EnumSet;

public enum SRResourceStates {
    COMMON(1),
    UNORDERED_ACCESS(2),
    COMPUTE_READ(4),
    PIXEL_READ(8),
    PIXEL_COMPUTE_READ(SRResourceStates.COMPUTE_READ.value | SRResourceStates.PIXEL_READ.value),
    COPY_SRC(16),
    COPY_DEST(32),
    GENERIC_READ(SRResourceStates.COPY_SRC.value | SRResourceStates.COMPUTE_READ.value),
    INDIRECT_ARGUMENT(64),
    PRESENT(128),
    RENDER_TARGET(256),
    DEPTH_ATTACHMENT(512);

    public final int value;

    private SRResourceStates(int value) {
        this.value = value;
    }

    public static int toBitmask(EnumSet<SRResourceStates> states) {
        int mask = 0;
        for (SRResourceStates state : states) {
            mask |= state.value;
        }
        return mask;
    }

    public static EnumSet<SRResourceStates> fromBitmask(int mask) {
        EnumSet<SRResourceStates> set = EnumSet.noneOf(SRResourceStates.class);
        for (SRResourceStates state : SRResourceStates.values()) {
            if ((mask & state.value) == 0) continue;
            set.add(state);
        }
        return set;
    }
}

