/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.srapi;

import io.homo.superresolution.core.SuperResolutionNative;
import io.homo.superresolution.srapi.SRCreateUpscaleContextDesc;
import io.homo.superresolution.srapi.SRDispatchUpscaleDesc;
import io.homo.superresolution.srapi.SRReturnCode;
import io.homo.superresolution.srapi.SRUpscaleContext;
import io.homo.superresolution.srapi.SRUpscaleContextQueryGpuMemoryInfoResult;
import io.homo.superresolution.srapi.SRUpscaleContextQueryResult;
import io.homo.superresolution.srapi.SRUpscaleContextQueryType;
import io.homo.superresolution.srapi.SRUpscaleContextQueryVersionInfoResult;
import io.homo.superresolution.srapi.SRUpscaleProvider;

public class SuperResolutionNativeAPI {
    public static SRReturnCode srCreateUpscaleContext(SRUpscaleContext outContext, SRUpscaleProvider provider, SRCreateUpscaleContextDesc desc) {
        if (provider.nativePtr < 1L) {
            return SRReturnCode.ERROR;
        }
        int code = SuperResolutionNative.NsrCreateUpscaleContext(outContext, provider.nativePtr, desc.device, desc.phyDevice, desc.upscaledSize.x, desc.upscaledSize.y, desc.renderSize.x, desc.renderSize.y, desc.flags);
        return SRReturnCode.fromValue(code);
    }

    public static SRReturnCode srDestroyUpscaleContext(SRUpscaleContext context) {
        if (context.nativePtr < 1L) {
            return SRReturnCode.ERROR;
        }
        return SRReturnCode.fromValue(SuperResolutionNative.NsrDestroyUpscaleContext(context.nativePtr));
    }

    public static SRReturnCode srDispatchUpscale(SRUpscaleContext context, SRDispatchUpscaleDesc desc) {
        if (context.nativePtr < 1L) {
            return SRReturnCode.ERROR;
        }
        int code = SuperResolutionNative.NsrDispatchUpscale(context.nativePtr, desc.commandList, desc.color, desc.depth, desc.motionVectors, desc.exposure, desc.reactive, desc.transparencyAndComposition, desc.output, desc.jitterOffset.x, desc.jitterOffset.y, desc.motionVectorScale.x, desc.motionVectorScale.y, desc.renderSize.x, desc.renderSize.y, desc.upscaleSize.x, desc.upscaleSize.y, desc.frameTimeDelta, desc.enableSharpening, desc.sharpness, desc.preExposure, desc.cameraNear, desc.cameraFar, desc.cameraFovAngleVertical, desc.viewSpaceToMetersFactor, desc.reset, desc.flags);
        return SRReturnCode.fromValue(code);
    }

    public static SRReturnCode srQueryUpscaleContext(SRUpscaleContext context, SRUpscaleContextQueryResult outResult, SRUpscaleContextQueryType queryType) {
        boolean typeTrue;
        if (context.nativePtr < 1L) {
            return SRReturnCode.ERROR;
        }
        switch (queryType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case VERSION_INFO: {
                boolean bl = outResult instanceof SRUpscaleContextQueryVersionInfoResult;
                break;
            }
            case GPU_MEMORY_INFO: {
                boolean bl = typeTrue = outResult instanceof SRUpscaleContextQueryGpuMemoryInfoResult;
            }
        }
        if (!typeTrue) {
            return SRReturnCode.ERROR;
        }
        return SRReturnCode.fromValue(SuperResolutionNative.NsrQueryUpscaleContext(context.nativePtr, outResult, queryType.value));
    }

    public static SRReturnCode srGetUpscaleProvider(SRUpscaleProvider provider, long providerId) {
        return SRReturnCode.fromValue(SuperResolutionNative.NsrGetUpscaleProvider(provider, providerId));
    }

    public static SRReturnCode srLoadUpscaleProvidersFromLibrary(String libPath, String getProvidersFuncName, String getProvidersCountFuncName) {
        return SRReturnCode.fromValue(SuperResolutionNative.NsrLoadUpscaleProvidersFromLibrary(libPath, getProvidersFuncName, getProvidersCountFuncName));
    }
}

