/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.icyllis.modernui.animation;

import io.homo.superresolution.thirdparty.icyllis.modernui.animation.TypeEvaluator;
import io.homo.superresolution.thirdparty.icyllis.modernui.graphics.MathUtil;
import javax.annotation.Nonnull;

public final class ColorEvaluator
implements TypeEvaluator<Integer> {
    private static final ColorEvaluator sInstance = new ColorEvaluator();

    private ColorEvaluator() {
    }

    @Nonnull
    public static ColorEvaluator getInstance() {
        return sInstance;
    }

    public static int evaluate(float fraction, int startValue, int endValue) {
        float startA = (float)(startValue >>> 24) / 255.0f;
        float startR = (float)(startValue >> 16 & 0xFF) / 255.0f;
        float startG = (float)(startValue >> 8 & 0xFF) / 255.0f;
        float startB = (float)(startValue & 0xFF) / 255.0f;
        float endA = (float)(endValue >>> 24) / 255.0f;
        float endR = (float)(endValue >> 16 & 0xFF) / 255.0f;
        float endG = (float)(endValue >> 8 & 0xFF) / 255.0f;
        float endB = (float)(endValue & 0xFF) / 255.0f;
        startR = (float)Math.pow(startR, 2.2);
        startG = (float)Math.pow(startG, 2.2);
        startB = (float)Math.pow(startB, 2.2);
        endR = (float)Math.pow(endR, 2.2);
        endG = (float)Math.pow(endG, 2.2);
        endB = (float)Math.pow(endB, 2.2);
        float a = MathUtil.lerp(startA, endA, fraction);
        float r = MathUtil.lerp(startR, endR, fraction);
        float g = MathUtil.lerp(startG, endG, fraction);
        float b = MathUtil.lerp(startB, endB, fraction);
        r = (float)Math.pow(r, 0.45454545454545453) * 255.0f;
        g = (float)Math.pow(g, 0.45454545454545453) * 255.0f;
        b = (float)Math.pow(b, 0.45454545454545453) * 255.0f;
        return Math.round(a *= 255.0f) << 24 | Math.round(r) << 16 | Math.round(g) << 8 | Math.round(b);
    }

    @Override
    @Nonnull
    public Integer evaluate(float fraction, Integer startValue, Integer endValue) {
        return ColorEvaluator.evaluate(fraction, startValue, endValue);
    }
}

