/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga;

import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaUnit;
import java.util.Objects;

public class YogaValue {
    public final float value;
    public final YogaUnit unit;
    public static final YogaValue ZERO = new YogaValue(0.0f, YogaUnit.POINT);
    public static final YogaValue UNDEFINED = new YogaValue(Float.NaN, YogaUnit.UNDEFINED);
    public static final YogaValue AUTO = new YogaValue(Float.NaN, YogaUnit.AUTO);

    public YogaValue(float value, YogaUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    public static YogaValue point(float value) {
        return new YogaValue(value, YogaUnit.POINT);
    }

    public static YogaValue percent(float value) {
        return new YogaValue(value, YogaUnit.PERCENT);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        YogaValue yogaValue = (YogaValue)o;
        if (this.unit != yogaValue.unit) {
            return false;
        }
        return switch (this.unit) {
            default -> throw new IncompatibleClassChangeError();
            case YogaUnit.UNDEFINED, YogaUnit.AUTO, YogaUnit.FIT_CONTENT, YogaUnit.MAX_CONTENT, YogaUnit.STRETCH -> true;
            case YogaUnit.POINT, YogaUnit.PERCENT -> Float.compare(this.value, yogaValue.value) == 0;
        };
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Float.valueOf(this.value), this.unit});
    }

    public String toString() {
        return switch (this.unit) {
            default -> throw new IncompatibleClassChangeError();
            case YogaUnit.UNDEFINED -> "undefined";
            case YogaUnit.POINT -> this.value + "pt";
            case YogaUnit.PERCENT -> this.value + "%";
            case YogaUnit.AUTO -> "auto";
            case YogaUnit.MAX_CONTENT -> "max-content";
            case YogaUnit.FIT_CONTENT -> "fit-content";
            case YogaUnit.STRETCH -> "stretch";
        };
    }

    public YogaValue neg() {
        return new YogaValue(-this.value, this.unit);
    }
}

