/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.node;

import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDisplay;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaNode;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Objects;

public class LayoutableChildren
implements Iterable<YogaNode> {
    private final YogaNode node;

    public LayoutableChildren(YogaNode node) {
        this.node = Objects.requireNonNull(node);
    }

    public LayoutIterator iterator() {
        if (this.node.getChildCount() > 0) {
            LayoutIterator iterator = new LayoutIterator(this.node, 0);
            if (this.node.getChild(0).getStyle().getDisplay() == YogaDisplay.CONTENTS) {
                iterator.skipContentsNodes();
            }
            return iterator;
        }
        return new LayoutIterator(null, 0);
    }

    public static class LayoutIterator
    implements Iterator<YogaNode> {
        private YogaNode currentNode;
        private int childIndex;
        private final LinkedList<NodeIndexPair> backtrack = new LinkedList();

        public LayoutIterator(YogaNode node, int childIndex) {
            this.currentNode = node;
            this.childIndex = childIndex;
        }

        @Override
        public boolean hasNext() {
            return this.currentNode != null;
        }

        @Override
        public YogaNode next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements in iterator");
            }
            YogaNode child = this.current();
            this.advance();
            return child;
        }

        public YogaNode current() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No element available");
            }
            return this.currentNode.getChild(this.childIndex);
        }

        private void advance() {
            if (this.childIndex + 1 >= this.currentNode.getChildCount()) {
                if (this.backtrack.isEmpty()) {
                    this.currentNode = null;
                    this.childIndex = 0;
                } else {
                    NodeIndexPair back = this.backtrack.removeFirst();
                    this.currentNode = back.node;
                    this.childIndex = back.index;
                    this.advance();
                }
            } else {
                ++this.childIndex;
                if (this.currentNode.getChild(this.childIndex).getStyle().getDisplay() == YogaDisplay.CONTENTS) {
                    this.skipContentsNodes();
                }
            }
        }

        void skipContentsNodes() {
            YogaNode contentsNode = this.currentNode.getChild(this.childIndex);
            while (contentsNode.getStyle().getDisplay() == YogaDisplay.CONTENTS && contentsNode.getChildCount() > 0) {
                this.backtrack.addFirst(new NodeIndexPair(this.currentNode, this.childIndex));
                this.currentNode = contentsNode;
                this.childIndex = 0;
                contentsNode = this.currentNode.getChild(this.childIndex);
            }
            if (contentsNode.getStyle().getDisplay() == YogaDisplay.CONTENTS) {
                this.advance();
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LayoutIterator)) {
                return false;
            }
            LayoutIterator other = (LayoutIterator)obj;
            return this.currentNode == other.currentNode && this.childIndex == other.childIndex;
        }

        public int hashCode() {
            return Objects.hash(this.currentNode, this.childIndex);
        }

        public LayoutIterator copy() {
            LayoutIterator result = new LayoutIterator(this.currentNode, this.childIndex);
            result.backtrack.addAll(this.backtrack);
            return result;
        }
    }

    private record NodeIndexPair(YogaNode node, int index) {
    }
}

