/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.api;

import io.homo.superresolution.common.upscale.DispatchResource;
import io.homo.superresolution.core.impl.Destroyable;
import io.homo.superresolution.core.impl.Resizable;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.impl.framebuffer.IFrameBuffer;

public abstract class AbstractAlgorithm
implements Resizable,
Destroyable {
    protected IFrameBuffer input;
    protected IFrameBuffer output;

    public abstract void init();

    public abstract boolean dispatch(DispatchResource var1);

    @Override
    public void destroy() {
        this.output.destroy();
    }

    @Override
    public void resize(int width, int height) {
        this.input.resizeFrameBuffer(width, height);
        this.output.resizeFrameBuffer(width, height);
    }

    public IFrameBuffer getInputFrameBuffer() {
        return this.input;
    }

    public void setInputFrameBuffer(IFrameBuffer input) {
        this.input = input;
    }

    public IFrameBuffer getOutputFrameBuffer() {
        return this.output;
    }

    public void setOutputFrameBuffer(IFrameBuffer output) {
        this.output = output;
    }

    public int getInputTextureId() {
        return this.input.getTextureId(FrameBufferAttachmentType.COLOR);
    }

    public int getOutputTextureId() {
        return this.output.getTextureId(FrameBufferAttachmentType.COLOR);
    }
}

