/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.gui.effect;

import io.homo.superresolution.common.debug.imgui.ImguiMain;
import io.homo.superresolution.common.minecraft.MinecraftRenderHandle;
import io.homo.superresolution.common.platform.Platform;
import io.homo.superresolution.core.gl.Gl;
import io.homo.superresolution.core.gl.GlState;
import io.homo.superresolution.core.gl.framebuffer.GlFrameBuffer;
import io.homo.superresolution.core.gl.shader.GlGeneralShaderProgram;
import io.homo.superresolution.core.gl.texture.GlTexture2D;
import io.homo.superresolution.core.gl.vertex.GlVertexArray;
import io.homo.superresolution.core.gl.vertex.GlVertexBuffer;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.impl.shader.ShaderSource;
import io.homo.superresolution.core.impl.texture.ITexture;
import io.homo.superresolution.core.impl.texture.TextureFormat;
import org.lwjgl.opengl.GL11;

public class BlurRenderer {
    public static final GlGeneralShaderProgram BLUR;
    public static final GlFrameBuffer blurFrameBuffer;
    public static final GlTexture2D blurTempTexture;
    public static final int MAX_LEVELS = 8;
    private static final float[] blurWeights;

    public static void compileShader() {
        if (!BlurRenderer.BLUR.compiled) {
            BLUR.compileShader();
        }
    }

    public static void copyTextureAndGenMipmap() {
        if (MinecraftRenderHandle.getOriginRenderTarget().getWidth() != blurTempTexture.getWidth() || MinecraftRenderHandle.getOriginRenderTarget().getHeight() != blurTempTexture.getHeight()) {
            blurTempTexture.resize(MinecraftRenderHandle.getOriginRenderTarget().getWidth(), MinecraftRenderHandle.getOriginRenderTarget().getHeight());
        }
        if (MinecraftRenderHandle.getOriginRenderTarget().getWidth() != blurFrameBuffer.getWidth() || MinecraftRenderHandle.getOriginRenderTarget().getHeight() != blurFrameBuffer.getHeight()) {
            blurFrameBuffer.resizeFrameBuffer(MinecraftRenderHandle.getOriginRenderTarget().getWidth(), MinecraftRenderHandle.getOriginRenderTarget().getHeight());
        }
        GlTexture2D dst = blurTempTexture;
        ITexture src = MinecraftRenderHandle.getOriginRenderTarget().getTexture(FrameBufferAttachmentType.COLOR);
        dst.copyFromTex(src.getTextureId());
        dst.generateMipmap();
    }

    public static void genBlurWeights(double phi, double m) {
        int i;
        double a = 1.0 / (m * Math.sqrt(Math.PI * 2));
        double sum = 0.0;
        for (i = 0; i < 8; ++i) {
            double b = Math.pow(Math.E, -(Math.pow((double)i - phi, 2.0) / (2.0 * m * m)));
            BlurRenderer.blurWeights[i] = (float)(a * b);
            sum += (double)blurWeights[i];
        }
        i = 0;
        while (i < 8) {
            int n = i++;
            blurWeights[n] = blurWeights[n] / (float)sum;
        }
    }

    public static void renderBlur() {
        BlurRenderer.compileShader();
        GlGeneralShaderProgram blurShader = BLUR;
        if (Platform.currentPlatform.isDevelopmentEnvironment()) {
            BlurRenderer.genBlurWeights(ImguiMain.getInstance().imguiLayer.blurPhi[0], ImguiMain.getInstance().imguiLayer.blurM[0]);
        } else {
            BlurRenderer.genBlurWeights(3.716, 0.69);
        }
        BlurRenderer.copyTextureAndGenMipmap();
        try (GlState ignored = new GlState();){
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            blurShader.use();
            blurFrameBuffer.bind(FrameBufferBindPoint.ALL);
            try (GlVertexArray vaoObj = new GlVertexArray();
                 GlVertexBuffer vbo = new GlVertexBuffer();){
                float[] vertices = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 0.0f, 1.0f};
                int vao = vaoObj.id();
                Gl.DSA.vertexArrayVertexBuffer(vao, 0, vbo.getId(), 0L, 16);
                Gl.DSA.vertexArrayAttribFormat(vao, 0, 2, 5126, false, 0);
                Gl.DSA.enableVertexArrayAttrib(vao, 0);
                Gl.DSA.vertexArrayAttribBinding(vao, 0, 0);
                Gl.DSA.vertexArrayAttribFormat(vao, 1, 2, 5126, false, 8);
                Gl.DSA.enableVertexArrayAttrib(vao, 1);
                Gl.DSA.vertexArrayAttribBinding(vao, 1, 0);
                vbo.uploadData(vertices, 35044);
                Gl.DSA.bindVertexArray(vao);
                blurShader.uniforms().safeTexture("uTexture").value(blurTempTexture).safeVec4("weightA").value(blurWeights[0], blurWeights[1], blurWeights[2], blurWeights[3]).safeVec4("weightB").value(blurWeights[4], blurWeights[5], blurWeights[6], blurWeights[7]);
                GL11.glDrawArrays((int)6, (int)0, (int)4);
            }
            blurShader.clear();
            GL11.glDepthMask((boolean)true);
        }
    }

    static {
        blurWeights = new float[8];
        BLUR = (GlGeneralShaderProgram)GlGeneralShaderProgram.create().addShaderSource(new ShaderSource(ShaderSource.Type.FRAGMENT, "/shader/gui_blur/blur.frag.glsl", true)).addShaderSource(new ShaderSource(ShaderSource.Type.VERTEX, "/shader/gui_blur/blur.vert.glsl", true)).setShaderName("gui-blur").build();
        blurFrameBuffer = GlFrameBuffer.create(TextureFormat.RGBA8, null, MinecraftRenderHandle.getScreenWidth(), MinecraftRenderHandle.getScreenHeight());
        blurTempTexture = GlTexture2D.create(MinecraftRenderHandle.getScreenWidth(), MinecraftRenderHandle.getScreenHeight(), TextureFormat.RGBA8, 0);
    }
}

