/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.upscale;

import io.homo.superresolution.api.registry.AlgorithmDescription;
import io.homo.superresolution.common.config.Config;
import io.homo.superresolution.common.minecraft.MinecraftRenderHandle;
import io.homo.superresolution.common.upscale.DispatchResource;
import io.homo.superresolution.common.upscale.MotionVectorsGenerator;
import io.homo.superresolution.core.gl.framebuffer.GlFrameBuffer;
import io.homo.superresolution.core.impl.Vec2;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class AlgorithmManager {
    public static AlgorithmParam param = new AlgorithmParam();

    public static GlFrameBuffer getMotionVectorsFrameBuffer() {
        return (GlFrameBuffer)MotionVectorsGenerator.getMotionVectorsFrameBuffer();
    }

    public static void destroy() {
    }

    public static void resize(int width, int height) {
        MotionVectorsGenerator.resize();
    }

    public static boolean isSupportAlgorithm(AlgorithmDescription<?> type) {
        return type.getRequirement().check().support();
    }

    public static void setMatrix(Matrix4f proj, Matrix4f view) {
        AlgorithmManager.setViewMatrix(view);
        AlgorithmManager.setProjectionMatrix(proj);
        Matrix4f curViewProjectionMatrix = new Matrix4f((Matrix4fc)proj);
        curViewProjectionMatrix.mul((Matrix4fc)view);
        AlgorithmManager.param.lastModelViewProjectionMatrix = AlgorithmManager.param.lastModelViewProjectionMatrix == null ? curViewProjectionMatrix : AlgorithmManager.param.currentModelViewProjectionMatrix;
        AlgorithmManager.param.currentModelViewProjectionMatrix = curViewProjectionMatrix;
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        Matrix4f viewMatrix = new Matrix4f().lookAt((float)camera.method_19326().field_1352, (float)camera.method_19326().field_1351, (float)camera.method_19326().field_1350, (float)(camera.method_19326().field_1352 + (double)camera.method_19335().x), (float)(camera.method_19326().field_1351 + (double)camera.method_19335().y), (float)(camera.method_19326().field_1350 + (double)camera.method_19335().z), camera.method_19336().x, camera.method_19336().y, camera.method_19336().z);
        AlgorithmManager.param.lastViewMatrix = AlgorithmManager.param.lastViewMatrix == null ? viewMatrix : AlgorithmManager.param.currentViewMatrix;
        AlgorithmManager.param.currentViewMatrix = viewMatrix;
    }

    private static void setProjectionMatrix(Matrix4f cur) {
        AlgorithmManager.param.lastProjectionMatrix = AlgorithmManager.param.lastProjectionMatrix == null ? new Matrix4f((Matrix4fc)cur) : AlgorithmManager.param.currentProjectionMatrix;
        AlgorithmManager.param.currentProjectionMatrix = new Matrix4f((Matrix4fc)cur);
    }

    private static void setViewMatrix(Matrix4f cur) {
        AlgorithmManager.param.lastModelViewMatrix = AlgorithmManager.param.lastModelViewMatrix == null ? new Matrix4f((Matrix4fc)cur) : AlgorithmManager.param.currentModelViewMatrix;
        AlgorithmManager.param.currentModelViewMatrix = new Matrix4f((Matrix4fc)cur);
    }

    public static DispatchResource getDispatchResource() {
        return new DispatchResource(MinecraftRenderHandle.getRenderWidth(), MinecraftRenderHandle.getRenderHeight(), new Vec2(MinecraftRenderHandle.getRenderWidth(), MinecraftRenderHandle.getRenderHeight()), MinecraftRenderHandle.getScreenWidth(), MinecraftRenderHandle.getScreenHeight(), new Vec2(MinecraftRenderHandle.getScreenWidth(), MinecraftRenderHandle.getScreenHeight()), MinecraftRenderHandle.getFrameCount(), MinecraftRenderHandle.frameTime, (float)AlgorithmManager.param.verticalFov, (float)Math.tan(AlgorithmManager.param.verticalFov / 2.0) * (float)MinecraftRenderHandle.getRenderWidth() / (float)MinecraftRenderHandle.getRenderHeight(), 0.05f, class_310.method_1551().field_1773.method_32796(), AlgorithmManager.param.currentModelViewMatrix, AlgorithmManager.param.currentProjectionMatrix, AlgorithmManager.param.currentModelViewProjectionMatrix, AlgorithmManager.param.currentViewMatrix, AlgorithmManager.param.lastModelViewMatrix, AlgorithmManager.param.lastProjectionMatrix, AlgorithmManager.param.lastModelViewProjectionMatrix, AlgorithmManager.param.lastViewMatrix, (GlFrameBuffer)MotionVectorsGenerator.getMotionVectorsFrameBuffer());
    }

    public static void init() {
        MotionVectorsGenerator.init();
    }

    public static void update() {
        AlgorithmManager.getMotionVectorsFrameBuffer().clearFrameBuffer();
        if (Config.isGenerateMotionVectors()) {
            MotionVectorsGenerator.update(AlgorithmManager.getDispatchResource());
        }
    }

    public static class AlgorithmParam {
        public Matrix4f lastProjectionMatrix;
        public Matrix4f currentProjectionMatrix;
        public Matrix4f currentModelViewMatrix;
        public Matrix4f lastModelViewMatrix;
        public Matrix4f currentModelViewProjectionMatrix;
        public Matrix4f lastModelViewProjectionMatrix;
        public Matrix4f currentViewMatrix;
        public Matrix4f lastViewMatrix;
        public double verticalFov = 11.4514f;
    }
}

