/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gl.shader;

import io.homo.superresolution.core.gl.shader.AbstractGlShaderProgram;
import io.homo.superresolution.core.impl.shader.ShaderSource;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractShaderProgramBuilder<T extends AbstractGlShaderProgram> {
    private final Map<String, String> shaderDefineList = new HashMap<String, String>();
    private final Map<ShaderSource.Type, ShaderSource> shaderSources = new EnumMap<ShaderSource.Type, ShaderSource>(ShaderSource.Type.class);
    private String shaderName = "";

    public AbstractShaderProgramBuilder<T> addShaderSource(ShaderSource source) {
        this.shaderSources.put(source.getType(), source);
        return this;
    }

    public AbstractShaderProgramBuilder<T> setShaderName(String shaderName) {
        this.shaderName = shaderName;
        return this;
    }

    public AbstractShaderProgramBuilder<T> addDefineText(String name, String value) {
        this.shaderDefineList.put(name, value);
        return this;
    }

    public AbstractShaderProgramBuilder<T> addDefineText(Map<String, String> map) {
        this.shaderDefineList.putAll(map);
        return this;
    }

    public abstract T build();

    protected T updateShader(AbstractGlShaderProgram shader) {
        this.shaderSources.forEach((key, shaderSource) -> shaderSource.setShaderDefines(new HashMap<String, String>(this.shaderDefineList)));
        shader.shaderDefineList = this.shaderDefineList;
        shader.shaderName = this.shaderName;
        shader.shaderSources.putAll(this.shaderSources);
        return (T)shader;
    }
}

